/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.logging;

import dev.morphia.logging.Logger;
import dev.morphia.logging.LoggerFactory;
import dev.morphia.logging.jdk.JDKLoggerFactory;
import java.util.ArrayList;
import java.util.List;

public final class MorphiaLoggerFactory {
    private static final List<String> FACTORIES = new ArrayList<String>();
    private static LoggerFactory loggerFactory;

    private MorphiaLoggerFactory() {
    }

    public static Logger get(Class<?> c) {
        MorphiaLoggerFactory.init();
        return loggerFactory.get(c);
    }

    private static synchronized void init() {
        if (loggerFactory == null) {
            MorphiaLoggerFactory.chooseLoggerFactory();
        }
    }

    private static void chooseLoggerFactory() {
        for (String f : FACTORIES) {
            loggerFactory = MorphiaLoggerFactory.newInstance(f);
            if (loggerFactory == null) continue;
            loggerFactory.get(MorphiaLoggerFactory.class).info("LoggerImplFactory set to " + loggerFactory.getClass().getName());
            return;
        }
        throw new IllegalStateException("Cannot instantiate any MorphiaLoggerFactory");
    }

    private static LoggerFactory newInstance(String f) {
        try {
            return (LoggerFactory)Class.forName(f).newInstance();
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static void registerLogger(Class<? extends LoggerFactory> factoryClass) {
        if (loggerFactory != null) {
            throw new IllegalStateException("LoggerImplFactory must be registered before logging is initialized.");
        }
        FACTORIES.add(0, factoryClass.getName());
    }

    public static void reset() {
        loggerFactory = null;
    }

    static {
        FACTORIES.add("dev.morphia.logging.slf4j.SLF4JLoggerImplFactory");
        FACTORIES.add(JDKLoggerFactory.class.getName());
    }
}

