/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.internal;

import dev.morphia.annotations.Serialized;
import dev.morphia.internal.MorphiaUtils;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.ValidationException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class PathTarget {
    private final List<String> segments;
    private boolean validateNames;
    private int position;
    private Mapper mapper;
    private MappedClass context;
    private MappedClass root;
    private MappedField target;
    private boolean resolved;

    public PathTarget(Mapper mapper, MappedClass root, String path) {
        this(mapper, root, path, true);
    }

    public <T> PathTarget(Mapper mapper, Class<T> clazz, String field) {
        this(mapper, mapper.getMappedClass(clazz), field, true);
    }

    public <T> PathTarget(Mapper mapper, Class<T> clazz, String field, boolean validateNames) {
        this(mapper, mapper.getMappedClass(clazz), field, validateNames);
    }

    public PathTarget(Mapper mapper, MappedClass root, String path, boolean validateNames) {
        this.segments = Arrays.asList(path.split("\\."));
        this.root = root;
        this.mapper = mapper;
        this.validateNames = validateNames;
        this.resolved = path.startsWith("$");
    }

    private boolean hasNext() {
        return this.position < this.segments.size();
    }

    public String translatedPath() {
        if (!this.resolved) {
            this.resolve();
        }
        return MorphiaUtils.join(this.segments, '.');
    }

    public MappedField getTarget() {
        if (!this.resolved) {
            this.resolve();
        }
        return this.target;
    }

    String next() {
        return this.segments.get(this.position++);
    }

    private void resolve() {
        this.context = this.root;
        this.position = 0;
        MappedField field = null;
        while (this.context != null && this.hasNext()) {
            String segment = this.next();
            if ("$".equals(segment) || segment.matches("[0-9]+")) {
                if (!this.hasNext()) break;
                segment = this.next();
            }
            if ((field = this.resolveField(segment)) != null) {
                if (this.hasNext() && (field.isReference() || field.hasAnnotation(Serialized.class))) {
                    this.failValidation();
                }
                this.translate(field.getNameToStore());
                if (!field.isMap() || !this.hasNext()) continue;
                this.next();
                continue;
            }
            if (!this.validateNames) continue;
            this.failValidation();
        }
        this.target = field;
        this.resolved = true;
    }

    private void failValidation() {
        throw new ValidationException(String.format("Could not resolve path '%s' against '%s'.", MorphiaUtils.join(this.segments, '.'), this.root.getClazz().getName()));
    }

    private void translate(String nameToStore) {
        this.segments.set(this.position - 1, nameToStore);
    }

    private MappedField resolveField(String segment) {
        MappedField mf = this.context.getMappedField(segment);
        if (mf == null) {
            mf = this.context.getMappedFieldByJavaField(segment);
        }
        if (mf == null) {
            Iterator<MappedClass> subTypes = this.mapper.getSubTypes(this.context).iterator();
            while (mf == null && subTypes.hasNext()) {
                this.context = subTypes.next();
                mf = this.resolveField(segment);
            }
        }
        if (mf != null) {
            this.context = this.mapper.getMappedClass(mf.getSubClass() != null ? mf.getSubClass() : mf.getConcreteType());
        }
        return mf;
    }

    public String toString() {
        return String.format("PathTarget{root=%s, segments=%s, target=%s}", this.root.getClazz().getSimpleName(), this.segments, this.target);
    }
}

