/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.geo;

import com.mongodb.client.model.geojson.Position;
import dev.morphia.geo.Geometry;
import dev.morphia.geo.GeometryCollection;
import dev.morphia.geo.LineString;
import dev.morphia.geo.MultiLineString;
import dev.morphia.geo.MultiPoint;
import dev.morphia.geo.MultiPolygon;
import dev.morphia.geo.Point;
import dev.morphia.geo.Polygon;
import java.util.ArrayList;
import java.util.List;

public final class GeoJson {
    private GeoJson() {
    }

    public static Point point(double latitude, double longitude) {
        return new Point(latitude, longitude);
    }

    public static Polygon polygon(Point ... points) {
        LineString exteriorBoundary = GeoJson.lineString(points);
        GeoJson.ensurePolygonIsClosed(exteriorBoundary);
        return new Polygon(exteriorBoundary, new LineString[0]);
    }

    public static LineString lineString(Point ... points) {
        return new LineString(points);
    }

    private static void ensurePolygonIsClosed(LineString points) {
        int size = points.getCoordinates().size();
        if (size > 0 && !points.getCoordinates().get(0).equals(points.getCoordinates().get(size - 1))) {
            throw new IllegalArgumentException("A polygon requires the starting point to be the same as the end to ensure a closed area");
        }
    }

    public static Polygon polygon(LineString exteriorBoundary, LineString ... interiorBoundaries) {
        GeoJson.ensurePolygonIsClosed(exteriorBoundary);
        for (LineString boundary : interiorBoundaries) {
            GeoJson.ensurePolygonIsClosed(boundary);
        }
        return new Polygon(exteriorBoundary, interiorBoundaries);
    }

    public static MultiPoint multiPoint(Point ... points) {
        return new MultiPoint(points);
    }

    public static MultiLineString multiLineString(LineString ... lines) {
        return new MultiLineString(lines);
    }

    public static MultiPolygon multiPolygon(Polygon ... polygons) {
        return new MultiPolygon(polygons);
    }

    public static GeometryCollection geometryCollection(Geometry ... geometries) {
        return new GeometryCollection(geometries);
    }

    public static List<Position> convertPoints(List<Point> values) {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (Point point : values) {
            positions.add(new Position(point.getLongitude(), point.getLatitude(), new double[0]));
        }
        return positions;
    }

    public static List<List<Position>> convertLineStrings(List<LineString> values) {
        ArrayList<List<Position>> positions = new ArrayList<List<Position>>();
        for (LineString line : values) {
            positions.add(GeoJson.convertPoints(line.getCoordinates()));
        }
        return positions;
    }
}

