/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.lang.reflect.Array;
import java.util.List;

public class ShortConverter
extends TypeConverter
implements SimpleValueConverter {
    public ShortConverter() {
        super(Short.TYPE, Short.class, short[].class, Short[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return val;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        if (val instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return this.convertToArray(type, (List)val);
        }
        return Short.parseShort(val.toString());
    }

    Object convertToArray(Class type, List<?> values) {
        Object array = Array.newInstance(type, values.size());
        for (int i = 0; i < values.size(); ++i) {
            Array.set(array, i, ((Number)values.get(i)).shortValue());
        }
        return array;
    }
}

