/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import java.time.LocalDateTime;
import java.util.Date;

public class LocalDateTimeConverter
extends TypeConverter
implements SimpleValueConverter {
    private Mapper mapper;

    public LocalDateTimeConverter(Mapper mapper) {
        super(LocalDateTime.class);
        this.mapper = mapper;
    }

    @Override
    public Object decode(Class<?> targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDateTime) {
            return val;
        }
        if (val instanceof Date) {
            return LocalDateTime.ofInstant(((Date)val).toInstant(), this.mapper.getOptions().getDateStorage().getZone());
        }
        throw new IllegalArgumentException("Can't convert to LocalDateTime from " + val);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return Date.from(((LocalDateTime)value).atZone(this.mapper.getOptions().getDateStorage().getZone()).toInstant());
    }
}

