/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public class LocalDateConverter
extends TypeConverter
implements SimpleValueConverter {
    private Mapper mapper;

    public LocalDateConverter(Mapper mapper) {
        super(LocalDate.class);
        this.mapper = mapper;
    }

    @Override
    public Object decode(Class<?> targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDate) {
            return val;
        }
        if (val instanceof Date) {
            return LocalDateTime.ofInstant(((Date)val).toInstant(), this.mapper.getOptions().getDateStorage().getZone()).toLocalDate();
        }
        throw new IllegalArgumentException("Can't convert to LocalDate from " + val);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        LocalDate date = (LocalDate)value;
        return Date.from(date.atStartOfDay().atZone(this.mapper.getOptions().getDateStorage().getZone()).toInstant());
    }
}

