/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.time.Instant;
import java.util.Date;

public class InstantConverter
extends TypeConverter
implements SimpleValueConverter {
    public InstantConverter() {
        super(Instant.class);
    }

    @Override
    public Object decode(Class<?> targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Instant) {
            return val;
        }
        if (val instanceof Date) {
            return ((Date)val).toInstant();
        }
        throw new IllegalArgumentException("Can't convert to Instant from " + val);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return Date.from((Instant)value);
    }
}

