/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import dev.morphia.converters.BigDecimalConverter;
import dev.morphia.converters.BooleanConverter;
import dev.morphia.converters.ByteConverter;
import dev.morphia.converters.CharArrayConverter;
import dev.morphia.converters.CharacterConverter;
import dev.morphia.converters.ClassConverter;
import dev.morphia.converters.Converters;
import dev.morphia.converters.CurrencyConverter;
import dev.morphia.converters.DateConverter;
import dev.morphia.converters.DoubleConverter;
import dev.morphia.converters.EnumConverter;
import dev.morphia.converters.EnumSetConverter;
import dev.morphia.converters.FloatConverter;
import dev.morphia.converters.IdentityConverter;
import dev.morphia.converters.InstantConverter;
import dev.morphia.converters.IntegerConverter;
import dev.morphia.converters.IterableConverter;
import dev.morphia.converters.KeyConverter;
import dev.morphia.converters.LocalDateConverter;
import dev.morphia.converters.LocalDateTimeConverter;
import dev.morphia.converters.LocalTimeConverter;
import dev.morphia.converters.LocaleConverter;
import dev.morphia.converters.LongConverter;
import dev.morphia.converters.MapOfValuesConverter;
import dev.morphia.converters.ObjectIdConverter;
import dev.morphia.converters.SerializedObjectConverter;
import dev.morphia.converters.ShortConverter;
import dev.morphia.converters.StringConverter;
import dev.morphia.converters.TimestampConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.converters.URIConverter;
import dev.morphia.converters.experimental.ReferenceConverter;
import dev.morphia.geo.GeometryConverter;
import dev.morphia.geo.GeometryShapeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;

public class DefaultConverters
extends Converters {
    public static final boolean JAVA_8;
    private final IdentityConverter identityConverter;
    private final SerializedObjectConverter serializedConverter;

    public DefaultConverters(Mapper mapper) {
        super(mapper);
        this.addConverter(new IdentityConverter(DBObject.class, BasicDBObject.class));
        this.addConverter(new EnumSetConverter());
        this.addConverter(new EnumConverter());
        this.addConverter(new StringConverter());
        this.addConverter(new CharacterConverter());
        this.addConverter(new ByteConverter());
        this.addConverter(new BooleanConverter());
        this.addConverter(new DoubleConverter());
        this.addConverter(new FloatConverter());
        this.addConverter(new LongConverter());
        this.addConverter(new LocaleConverter());
        this.addConverter(new ShortConverter());
        this.addConverter(new IntegerConverter());
        this.addConverter(new CharArrayConverter());
        this.addConverter(new DateConverter());
        this.addConverter(new URIConverter());
        this.addConverter(new KeyConverter());
        this.addConverter(new MapOfValuesConverter());
        this.addConverter(new IterableConverter());
        this.addConverter(new ClassConverter());
        this.addConverter(new ObjectIdConverter());
        this.addConverter(new TimestampConverter());
        this.addConverter(new BigDecimalConverter());
        this.addConverter(new CurrencyConverter());
        this.addConverter(new ReferenceConverter(mapper));
        this.addConverter(new GeometryShapeConverter.PointConverter());
        this.addConverter(new GeometryShapeConverter.LineStringConverter());
        this.addConverter(new GeometryShapeConverter.MultiPointConverter());
        this.addConverter(new GeometryShapeConverter.MultiLineStringConverter());
        this.addConverter(new GeometryShapeConverter.PolygonConverter());
        this.addConverter(new GeometryShapeConverter.MultiPolygonConverter());
        this.addConverter(new GeometryConverter());
        if (JAVA_8) {
            this.addConverter(new LocalTimeConverter());
            this.addConverter(new LocalDateTimeConverter(mapper));
            this.addConverter(new LocalDateConverter(mapper));
            this.addConverter(new InstantConverter());
        }
        this.identityConverter = new IdentityConverter(new Class[0]);
        this.serializedConverter = new SerializedObjectConverter();
    }

    @Override
    protected TypeConverter getEncoder(Class c) {
        TypeConverter encoder = super.getEncoder(c);
        if (encoder == null && this.identityConverter.canHandle(c)) {
            encoder = this.identityConverter;
        }
        return encoder;
    }

    @Override
    protected TypeConverter getEncoder(Object val, MappedField mf) {
        if (this.serializedConverter.canHandle(mf)) {
            return this.serializedConverter;
        }
        TypeConverter encoder = super.getEncoder(val, mf);
        if (encoder == null && (this.identityConverter.canHandle(mf) || val != null && this.identityConverter.isSupported((Class)val.getClass(), mf))) {
            encoder = this.identityConverter;
        }
        return encoder;
    }

    static {
        boolean found;
        try {
            Class.forName("java.time.LocalDateTime");
            found = true;
        }
        catch (ClassNotFoundException e) {
            found = false;
        }
        JAVA_8 = found;
    }
}

