/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.util.Currency;
import java.util.Locale;

public class CurrencyConverter
extends TypeConverter
implements SimpleValueConverter {
    public CurrencyConverter() {
        super(Currency.class);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        return this.isValidCurrency(value) ? ((Currency)value).getCurrencyCode() : null;
    }

    @Override
    public Object decode(Class<?> targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        if (fromDBObject instanceof Locale) {
            return Currency.getInstance((Locale)fromDBObject);
        }
        return Currency.getInstance((String)fromDBObject);
    }

    private boolean isValidCurrency(Object potentialCurrency) {
        return potentialCurrency != null && potentialCurrency instanceof Currency;
    }
}

