/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.lang.reflect.Array;

public class ByteConverter
extends TypeConverter
implements SimpleValueConverter {
    public ByteConverter() {
        super(Byte.TYPE, Byte.class, byte[].class, Byte[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val.getClass().equals(targetClass)) {
            return val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        if (targetClass.isArray() && val.getClass().equals(byte[].class)) {
            return this.convertToWrapperArray((byte[])val);
        }
        return Byte.parseByte(val.toString());
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value instanceof Byte[]) {
            return super.encode(this.convertToPrimitiveArray((Byte[])value), optionalExtraInfo);
        }
        return super.encode(value, optionalExtraInfo);
    }

    Object convertToPrimitiveArray(Byte[] values) {
        int length = values.length;
        Object array = Array.newInstance(Byte.TYPE, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, values[i]);
        }
        return array;
    }

    Object convertToWrapperArray(byte[] values) {
        int length = values.length;
        Object array = Array.newInstance(Byte.class, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, values[i]);
        }
        return array;
    }
}

