/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.utils.ReflectionUtils;
import java.util.List;

public class BooleanConverter
extends TypeConverter
implements SimpleValueConverter {
    public BooleanConverter() {
        super(Boolean.TYPE, Boolean.class, boolean[].class, Boolean[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue() != 0;
        }
        if (val instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)val);
        }
        return Boolean.parseBoolean(val.toString());
    }
}

