/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.UnwindOptions;
import dev.morphia.DatastoreImpl;
import dev.morphia.aggregation.AggregationPipeline;
import dev.morphia.aggregation.GeoNear;
import dev.morphia.aggregation.Group;
import dev.morphia.aggregation.Projection;
import dev.morphia.geo.GeometryShapeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.BucketAutoOptions;
import dev.morphia.query.BucketOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.internal.MorphiaCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationPipelineImpl
implements AggregationPipeline {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationPipelineImpl.class);
    private final DBCollection collection;
    private final Class source;
    private final List<DBObject> stages = new ArrayList<DBObject>();
    private final Mapper mapper;
    private final DatastoreImpl datastore;
    private boolean firstStage;

    public AggregationPipelineImpl(DatastoreImpl datastore, DBCollection collection, Class source) {
        this.datastore = datastore;
        this.collection = collection;
        this.mapper = datastore.getMapper();
        this.source = source;
    }

    public List<DBObject> getStages() {
        return this.stages;
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target) {
        return this.aggregate(target, AggregationOptions.builder().build(), this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options) {
        return this.aggregate(target, options, this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        return this.aggregate(this.datastore.getCollection((Class)target).getName(), target, options, readPreference);
    }

    @Override
    public <U> Iterator<U> aggregate(String collectionName, Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        LOG.debug("stages = " + this.stages);
        Cursor cursor = this.collection.aggregate(this.stages, options, readPreference);
        return new MorphiaCursor<U>(this.datastore, cursor, this.mapper, target, this.mapper.createEntityCache());
    }

    @Override
    public AggregationPipeline geoNear(GeoNear geoNear) {
        BasicDBObject geo = new BasicDBObject();
        GeometryShapeConverter.PointConverter pointConverter = new GeometryShapeConverter.PointConverter();
        pointConverter.setMapper(this.mapper);
        this.putIfNull((DBObject)geo, "near", geoNear.getNearAsDBObject(pointConverter));
        this.putIfNull((DBObject)geo, "distanceField", geoNear.getDistanceField());
        this.putIfNull((DBObject)geo, "limit", geoNear.getLimit());
        this.putIfNull((DBObject)geo, "num", geoNear.getMaxDocuments());
        this.putIfNull((DBObject)geo, "maxDistance", geoNear.getMaxDistance());
        if (geoNear.getQuery() != null) {
            geo.put("query", (Object)geoNear.getQuery().getQueryObject());
        }
        this.putIfNull((DBObject)geo, "spherical", geoNear.getSpherical());
        this.putIfNull((DBObject)geo, "distanceMultiplier", geoNear.getDistanceMultiplier());
        this.putIfNull((DBObject)geo, "includeLocs", geoNear.getIncludeLocations());
        this.putIfNull((DBObject)geo, "uniqueDocs", geoNear.getUniqueDocuments());
        this.stages.add((DBObject)new BasicDBObject("$geoNear", (Object)geo));
        return this;
    }

    @Override
    public AggregationPipeline group(Group ... groupings) {
        return this.group((String)null, groupings);
    }

    @Override
    public AggregationPipeline group(String id, Group ... groupings) {
        BasicDBObject group = new BasicDBObject();
        group.put("_id", id != null ? "$" + id : null);
        for (Group grouping : groupings) {
            group.putAll((BSONObject)this.toDBObject(grouping));
        }
        this.stages.add((DBObject)new BasicDBObject("$group", (Object)group));
        return this;
    }

    @Override
    public AggregationPipeline group(List<Group> id, Group ... groupings) {
        if (id != null) {
            BasicDBObject idGroup = new BasicDBObject();
            for (Group group : id) {
                idGroup.putAll((BSONObject)this.toDBObject(group));
            }
            BasicDBObject group = new BasicDBObject("_id", (Object)idGroup);
            for (Group grouping : groupings) {
                group.putAll((BSONObject)this.toDBObject(grouping));
            }
            this.stages.add((DBObject)new BasicDBObject("$group", (Object)group));
        }
        return this;
    }

    @Override
    public AggregationPipeline limit(int count) {
        this.stages.add((DBObject)new BasicDBObject("$limit", (Object)count));
        return this;
    }

    @Override
    public AggregationPipeline lookup(String from, String localField, String foreignField, String as) {
        this.stages.add((DBObject)new BasicDBObject("$lookup", (Object)new BasicDBObject("from", (Object)from).append("localField", (Object)localField).append("foreignField", (Object)foreignField).append("as", (Object)as)));
        return this;
    }

    @Override
    public AggregationPipeline match(Query query) {
        this.stages.add((DBObject)new BasicDBObject("$match", (Object)query.getQueryObject()));
        return this;
    }

    @Override
    public AggregationPipeline sample(int sampleSize) {
        this.stages.add((DBObject)new BasicDBObject("$sample", (Object)new BasicDBObject("size", (Object)sampleSize)));
        return this;
    }

    @Override
    public <U> Iterator<U> out(Class<U> target) {
        return this.out(this.datastore.getCollection((Class)target).getName(), target);
    }

    @Override
    public <U> Iterator<U> out(Class<U> target, AggregationOptions options) {
        return this.out(this.datastore.getCollection((Class)target).getName(), target, options);
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target) {
        return this.out(collectionName, target, AggregationOptions.builder().build());
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target, AggregationOptions options) {
        this.stages.add((DBObject)new BasicDBObject("$out", (Object)collectionName));
        return this.aggregate(target, options);
    }

    @Override
    public AggregationPipeline project(Projection ... projections) {
        this.firstStage = this.stages.isEmpty();
        BasicDBObject dbObject = new BasicDBObject();
        for (Projection projection : projections) {
            dbObject.putAll((BSONObject)this.toDBObject(projection));
        }
        this.stages.add((DBObject)new BasicDBObject("$project", (Object)dbObject));
        return this;
    }

    @Override
    public AggregationPipeline skip(int count) {
        this.stages.add((DBObject)new BasicDBObject("$skip", (Object)count));
        return this;
    }

    @Override
    public AggregationPipeline sort(Sort ... sorts) {
        BasicDBObject sortList = new BasicDBObject();
        for (Sort sort : sorts) {
            sortList.put(sort.getField(), (Object)sort.getOrder());
        }
        this.stages.add((DBObject)new BasicDBObject("$sort", (Object)sortList));
        return this;
    }

    @Override
    public AggregationPipeline unwind(String field) {
        this.stages.add((DBObject)new BasicDBObject("$unwind", (Object)("$" + field)));
        return this;
    }

    @Override
    public AggregationPipeline unwind(String field, UnwindOptions options) {
        BasicDBObject unwindOptions = new BasicDBObject("path", (Object)("$" + field)).append("preserveNullAndEmptyArrays", (Object)options.isPreserveNullAndEmptyArrays());
        String includeArrayIndex = options.getIncludeArrayIndex();
        if (includeArrayIndex != null) {
            unwindOptions.append("includeArrayIndex", (Object)includeArrayIndex);
        }
        this.stages.add((DBObject)new BasicDBObject("$unwind", (Object)unwindOptions));
        return this;
    }

    @Override
    public AggregationPipeline sortByCount(String field) {
        this.stages.add((DBObject)new BasicDBObject("$sortByCount", (Object)("$" + field)));
        return this;
    }

    @Override
    public AggregationPipeline bucket(String field, List<?> boundaries) {
        return this.bucket(field, boundaries, new BucketOptions());
    }

    @Override
    public AggregationPipeline bucket(String field, List<?> boundaries, BucketOptions options) {
        if (boundaries == null || boundaries.size() < 2) {
            throw new RuntimeException("Boundaries list should be present and has at least 2 elements");
        }
        DBObject dbObject = options.toDBObject();
        dbObject.put("groupBy", (Object)("$" + field));
        dbObject.put("boundaries", boundaries);
        this.stages.add((DBObject)new BasicDBObject("$bucket", (Object)dbObject));
        return this;
    }

    @Override
    public AggregationPipeline bucketAuto(String field, int bucketCount) {
        return this.bucketAuto(field, bucketCount, new BucketAutoOptions());
    }

    @Override
    public AggregationPipeline bucketAuto(String field, int bucketCount, BucketAutoOptions options) {
        if (bucketCount < 1) {
            throw new RuntimeException("bucket count should be more than 0");
        }
        DBObject dbObject = options.toDBObject();
        dbObject.put("groupBy", (Object)("$" + field));
        dbObject.put("buckets", (Object)bucketCount);
        this.stages.add((DBObject)new BasicDBObject("$bucketAuto", (Object)dbObject));
        return this;
    }

    private DBObject toDBObject(Projection projection) {
        MappedField field;
        String target = this.firstStage ? ((field = this.mapper.getMappedClass(this.source).getMappedField(projection.getTarget())) != null ? field.getNameToStore() : projection.getTarget()) : projection.getTarget();
        if (projection.getProjections() != null) {
            List<Projection> list = projection.getProjections();
            BasicDBObject projections = new BasicDBObject();
            for (Projection subProjection : list) {
                projections.putAll((BSONObject)this.toDBObject(subProjection));
            }
            return new BasicDBObject(target, (Object)projections);
        }
        if (projection.getSource() != null) {
            return new BasicDBObject(target, (Object)projection.getSource());
        }
        if (projection.getArguments() != null) {
            DBObject args = this.toExpressionArgs(projection.getArguments());
            if (target == null) {
                Object firstArg;
                if (args instanceof List && ((List)args).size() == 1 && (firstArg = ((List)args).get(0)) instanceof DBObject) {
                    return (DBObject)firstArg;
                }
                return args;
            }
            if (args instanceof List && ((List)args).size() == 1) {
                return new BasicDBObject(target, ((List)args).get(0));
            }
            return new BasicDBObject(target, (Object)args);
        }
        return new BasicDBObject(target, (Object)(projection.isSuppressed() ? 0 : 1));
    }

    private DBObject toDBObject(Group group) {
        BasicDBObject dbObject = new BasicDBObject();
        if (group.getAccumulator() != null) {
            dbObject.put((Object)group.getName(), (Object)group.getAccumulator().toDBObject());
        } else if (group.getProjections() != null) {
            BasicDBObject projection = new BasicDBObject();
            for (Projection p : group.getProjections()) {
                projection.putAll((BSONObject)this.toDBObject(p));
            }
            dbObject.put((Object)group.getName(), (Object)projection);
        } else if (group.getNested() != null) {
            dbObject.put((Object)group.getName(), (Object)this.toDBObject(group.getNested()));
        } else {
            dbObject.put((Object)group.getName(), (Object)group.getSourceField());
        }
        return dbObject;
    }

    private void putIfNull(DBObject dbObject, String name, Object value) {
        if (value != null) {
            dbObject.put(name, value);
        }
    }

    private DBObject toExpressionArgs(List<Object> args) {
        BasicDBList result = new BasicDBList();
        for (Object arg : args) {
            if (arg instanceof Projection) {
                Projection projection = (Projection)arg;
                if (projection.getArguments() != null || projection.getProjections() != null || projection.getSource() != null) {
                    result.add((Object)this.toDBObject(projection));
                    continue;
                }
                result.add((Object)("$" + projection.getTarget()));
                continue;
            }
            result.add(arg);
        }
        return result;
    }

    public String toString() {
        return this.stages.toString();
    }
}

