/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import dev.morphia.Datastore;
import dev.morphia.MapreduceType;
import dev.morphia.annotations.NotSaved;
import dev.morphia.annotations.Transient;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.cache.EntityCache;
import dev.morphia.query.MorphiaIterator;
import dev.morphia.query.Query;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotSaved
@Deprecated
public class MapreduceResults<T>
implements Iterable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MapreduceResults.class);
    private final Stats counts = new Stats();
    private MapReduceOutput output;
    private String outputCollectionName;
    private MapReduceCommand.OutputType outputType;
    private Query<T> query;
    @Transient
    private Class<T> clazz;
    @Transient
    private Mapper mapper;
    @Transient
    private EntityCache cache;
    private Datastore datastore;

    public MapreduceResults(MapReduceOutput output) {
        this.output = output;
        this.outputCollectionName = output.getCollectionName();
    }

    public Query<T> createQuery() {
        if (this.outputType == MapReduceCommand.OutputType.INLINE) {
            throw new MappingException("No collection available for inline mapreduce jobs");
        }
        return this.query.cloneQuery();
    }

    public Stats getCounts() {
        return this.counts;
    }

    public long getElapsedMillis() {
        return this.output.getDuration();
    }

    @Deprecated
    public String getError() {
        LOG.warn("MapreduceResults.getError() will always return null.");
        return null;
    }

    public Iterator<T> getInlineResults() {
        return new MorphiaIterator(this.datastore, this.output.results().iterator(), this.mapper, this.clazz, null, this.cache);
    }

    @Deprecated
    public MapreduceType getType() {
        if (this.outputType == MapReduceCommand.OutputType.REDUCE) {
            return MapreduceType.REDUCE;
        }
        if (this.outputType == MapReduceCommand.OutputType.MERGE) {
            return MapreduceType.MERGE;
        }
        if (this.outputType == MapReduceCommand.OutputType.INLINE) {
            return MapreduceType.INLINE;
        }
        return MapreduceType.REPLACE;
    }

    @Deprecated
    void setType(MapreduceType type) {
        this.outputType = type.toOutputType();
    }

    public MapReduceCommand.OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(MapReduceCommand.OutputType outputType) {
        this.outputType = outputType;
    }

    @Deprecated
    public boolean isOk() {
        LOG.warn("MapreduceResults.isOk() will always return true.");
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.outputType == MapReduceCommand.OutputType.INLINE ? this.getInlineResults() : this.createQuery().fetch().iterator();
    }

    public void setInlineRequiredOptions(Datastore datastore, Class<T> clazz, Mapper mapper, EntityCache cache) {
        this.mapper = mapper;
        this.datastore = datastore;
        this.clazz = clazz;
        this.cache = cache;
    }

    String getOutputCollectionName() {
        return this.outputCollectionName;
    }

    void setQuery(Query<T> query) {
        this.query = query;
    }

    public class Stats {
        public int getEmitCount() {
            return MapreduceResults.this.output.getEmitCount();
        }

        public int getInputCount() {
            return MapreduceResults.this.output.getInputCount();
        }

        public int getOutputCount() {
            return MapreduceResults.this.output.getOutputCount();
        }
    }
}

