/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.DBCollection;
import com.mongodb.MapReduceCommand;
import com.mongodb.ReadPreference;
import com.mongodb.client.model.Collation;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.Query;
import dev.morphia.query.QueryException;
import dev.morphia.utils.Assert;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Deprecated
public class MapReduceOptions<T> {
    private String outputDB;
    private String outputCollection;
    private String inputCollection;
    private String map;
    private String reduce;
    private MapReduceCommand.OutputType outputType;
    private Query query;
    private String finalize;
    private ReadPreference readPreference;
    private int limit;
    private long maxTimeMS;
    private Map<String, Object> scope;
    private boolean jsMode;
    private boolean verbose;
    private boolean bypassDocumentValidation;
    private Collation collation;
    private Class<T> resultType;

    public MapReduceOptions<T> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public MapReduceOptions<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public MapReduceOptions<T> finalize(String finalize) {
        this.finalize = finalize;
        return this;
    }

    public MapReduceOptions<T> jsMode(Boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public MapReduceOptions<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MapReduceOptions<T> map(String map) {
        Assert.parametersNotNull("map", map);
        Assert.parameterNotEmpty("map", map);
        this.map = map;
        return this;
    }

    public MapReduceOptions<T> maxTimeMS(long maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    public MapReduceOptions<T> inputCollection(String name) {
        this.inputCollection = name;
        return this;
    }

    public MapReduceOptions<T> outputCollection(String name) {
        this.outputCollection = name;
        return this;
    }

    public MapReduceOptions<T> outputDB(String outputDB) {
        this.outputDB = outputDB;
        return this;
    }

    public MapReduceOptions<T> outputType(MapReduceCommand.OutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    public MapReduceOptions<T> query(Query query) {
        Assert.parametersNotNull("query", query);
        this.query = query;
        return this;
    }

    public MapReduceOptions<T> readPreference(ReadPreference preference) {
        this.readPreference = preference;
        return this;
    }

    public MapReduceOptions<T> reduce(String reduce) {
        Assert.parametersNotNull("reduce", reduce);
        Assert.parameterNotEmpty("reduce", reduce);
        this.reduce = reduce;
        return this;
    }

    public MapReduceOptions<T> resultType(Class<T> resultType) {
        this.resultType = resultType;
        return this;
    }

    public MapReduceOptions<T> scope(Map<String, Object> scope) {
        this.scope = scope;
        return this;
    }

    public MapReduceOptions<T> verbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    MapReduceCommand.OutputType getOutputType() {
        return this.outputType;
    }

    Query getQuery() {
        return this.query;
    }

    Class<T> getResultType() {
        return this.resultType;
    }

    MapReduceCommand toCommand(Mapper mapper) {
        if (this.query.getOffset() != 0 || this.query.getFieldsObject() != null) {
            throw new QueryException("mapReduce does not allow the offset/retrievedFields query ");
        }
        DBCollection dbColl = this.inputCollection != null ? this.getQuery().getCollection().getDB().getCollection(this.inputCollection) : this.query.getCollection();
        String target = this.outputCollection != null ? this.outputCollection : mapper.getMappedClass(this.resultType).getCollectionName();
        MapReduceCommand command = new MapReduceCommand(dbColl, this.map, this.reduce, target, this.outputType, this.query.getQueryObject());
        command.setBypassDocumentValidation(Boolean.valueOf(this.bypassDocumentValidation));
        command.setCollation(this.collation);
        command.setFinalize(this.finalize);
        command.setJsMode(Boolean.valueOf(this.jsMode));
        command.setLimit(this.limit);
        command.setMaxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        command.setOutputDB(this.outputDB);
        command.setReadPreference(this.readPreference);
        command.setScope(this.scope);
        command.setSort(this.query.getSortObject());
        command.setVerbose(Boolean.valueOf(this.verbose));
        return command;
    }
}

