/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import dev.morphia.AnnotationBuilder;
import dev.morphia.FieldBuilder;
import dev.morphia.IndexBuilder;
import dev.morphia.IndexOptionsBuilder;
import dev.morphia.annotations.Collation;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Indexes;
import dev.morphia.annotations.NotSaved;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Serialized;
import dev.morphia.annotations.Text;
import dev.morphia.internal.MorphiaUtils;
import dev.morphia.mapping.MappedClass;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.utils.IndexType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IndexHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IndexHelper.class);
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();
    private final Mapper mapper;
    private final MongoDatabase database;

    IndexHelper(Mapper mapper, MongoDatabase database) {
        this.mapper = mapper;
        this.database = database;
    }

    private void calculateWeights(Index index, com.mongodb.client.model.IndexOptions indexOptions) {
        Document weights = new Document();
        for (Field field : index.fields()) {
            if (field.weight() == -1) continue;
            if (field.type() != IndexType.TEXT) {
                throw new MappingException("Weight values only apply to text indexes: " + Arrays.toString(index.fields()));
            }
            weights.put(field.value(), (Object)field.weight());
        }
        if (!weights.isEmpty()) {
            indexOptions.weights((Bson)weights);
        }
    }

    Index convert(Text text, String nameToStore) {
        return new IndexBuilder().options(text.options()).fields(Collections.singletonList(new FieldBuilder().value(nameToStore).type(IndexType.TEXT).weight(text.value())));
    }

    Index convert(Indexed indexed, String nameToStore) {
        if (indexed.dropDups() || indexed.options().dropDups()) {
            LOG.warn("Support for dropDups has been removed from the server.  Please remove this setting.");
        }
        Map<String, Object> newOptions = this.extractOptions(indexed.options());
        Map<String, Object> oldOptions = this.extractOldOptions(indexed);
        if (!oldOptions.isEmpty() && !newOptions.isEmpty()) {
            throw new MappingException("Mixed usage of deprecated @Indexed values with the new @IndexOption values is not allowed.  Please migrate all settings to @IndexOptions");
        }
        List<Field> fields = Collections.singletonList(new FieldBuilder().value(nameToStore).type(IndexType.fromValue(indexed.value().toIndexValue())));
        return newOptions.isEmpty() ? new IndexBuilder().options(new IndexOptionsBuilder().migrate(indexed)).fields(fields) : new IndexBuilder().options(indexed.options()).fields(fields);
    }

    private List<Index> collectFieldIndexes(MappedClass mc) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (MappedField mf : mc.getPersistenceFields()) {
            if (mf.hasAnnotation(Indexed.class)) {
                list.add(this.convert(mf.getAnnotation(Indexed.class), mf.getNameToStore()));
                continue;
            }
            if (!mf.hasAnnotation(Text.class)) continue;
            list.add(this.convert(mf.getAnnotation(Text.class), mf.getNameToStore()));
        }
        return list;
    }

    private List<Index> collectIndexes(MappedClass mc, List<MappedClass> parentMCs) {
        if (parentMCs.contains(mc) || mc.getEmbeddedAnnotation() != null && parentMCs.isEmpty()) {
            return Collections.emptyList();
        }
        List<Index> indexes = this.collectTopLevelIndexes(mc);
        indexes.addAll(this.collectFieldIndexes(mc));
        if (!this.mapper.getOptions().isDisableEmbeddedIndexes()) {
            indexes.addAll(this.collectNestedIndexes(mc, parentMCs));
        }
        return indexes;
    }

    @Deprecated
    private List<Index> collectNestedIndexes(MappedClass mc, List<MappedClass> parentMCs) {
        ArrayList<Index> list = new ArrayList<Index>();
        for (MappedField mf : mc.getPersistenceFields()) {
            if (mf.isTypeMongoCompatible() || mf.hasAnnotation(Reference.class) || mf.hasAnnotation(Serialized.class) || mf.hasAnnotation(NotSaved.class) || mf.isTransient()) continue;
            ArrayList<MappedClass> parents = new ArrayList<MappedClass>(parentMCs);
            parents.add(mc);
            ArrayList<MappedClass> classes = new ArrayList<MappedClass>();
            MappedClass mappedClass = this.mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass());
            classes.add(mappedClass);
            if (mappedClass.isInterface() || mappedClass.isAbstract()) {
                classes.addAll(this.mapper.getSubTypes(mappedClass));
            }
            for (MappedClass aClass : classes) {
                for (Index index : this.collectIndexes(aClass, parents)) {
                    LOG.warn("Embedded index generation is being removed from 2.0.  Please migrate any index definitions you need to the parent entity to ensure these indexes continue to be generated in future versions.");
                    list.add(new IndexBuilder(index, mf.getNameToStore()));
                }
            }
        }
        return list;
    }

    private List<Index> collectTopLevelIndexes(MappedClass mc) {
        ArrayList<Index> list = new ArrayList<Index>();
        if (mc != null) {
            List annotations = mc.getAnnotations(Indexes.class);
            if (annotations != null) {
                for (Indexes indexes : annotations) {
                    Index[] indexArray = indexes.value();
                    int n = indexArray.length;
                    for (int i = 0; i < n; ++i) {
                        Index index;
                        Index updated = index = indexArray[i];
                        if (index.fields().length == 0) {
                            LOG.warn(String.format("This index on '%s' is using deprecated configuration options.  Please update to use the fields value on @Index: %s", mc.getClazz().getName(), index.toString()));
                            updated = new IndexBuilder().migrate(index);
                        }
                        ArrayList<Field> fields = new ArrayList<Field>();
                        for (Field field : updated.fields()) {
                            fields.add(new FieldBuilder().value(this.findField(mc, index.options(), Arrays.asList(field.value().split("\\.")))).type(field.type()).weight(field.weight()));
                        }
                        list.add(this.replaceFields(updated, fields));
                    }
                }
            }
            list.addAll(this.collectTopLevelIndexes(mc.getSuperClass()));
        }
        return list;
    }

    private Map<String, Object> extractOptions(IndexOptions options) {
        return AnnotationBuilder.toMap(options);
    }

    private Map<String, Object> extractOldOptions(Indexed indexed) {
        Map<String, Object> map = AnnotationBuilder.toMap(indexed);
        map.remove("options");
        map.remove("value");
        return map;
    }

    private MappingException pathFail(MappedClass mc, List<String> path) {
        return new MappingException(String.format("Could not resolve path '%s' against '%s'.", MorphiaUtils.join(path, '.'), mc.getClazz().getName()));
    }

    private Index replaceFields(Index original, List<Field> list) {
        return new IndexBuilder(original).fields(list);
    }

    private BsonDocument toBsonDocument(String key, Object value) {
        BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
        writer.writeStartDocument();
        writer.writeName(key);
        this.database.getCodecRegistry().get(value.getClass()).encode((BsonWriter)writer, value, ENCODER_CONTEXT);
        writer.writeEndDocument();
        return writer.getDocument();
    }

    BsonDocument calculateKeys(MappedClass mc, Index index) {
        BsonDocument keys = new BsonDocument();
        for (Field field : index.fields()) {
            String path;
            try {
                path = this.findField(mc, index.options(), new ArrayList<String>(Arrays.asList(field.value().split("\\."))));
            }
            catch (Exception e) {
                path = field.value();
                String message = String.format("The path '%s' can not be validated against '%s' and may represent an invalid index", path, mc.getClazz().getName());
                if (!index.options().disableValidation()) {
                    throw new MappingException(message);
                }
                LOG.warn(message);
            }
            keys.putAll((Map)this.toBsonDocument(path, field.type().toIndexValue()));
        }
        return keys;
    }

    com.mongodb.client.model.IndexOptions convert(IndexOptions options, boolean background) {
        if (options.dropDups()) {
            LOG.warn("Support for dropDups has been removed from the server.  Please remove this setting.");
        }
        com.mongodb.client.model.IndexOptions indexOptions = new com.mongodb.client.model.IndexOptions().background(options.background() || background).sparse(options.sparse()).unique(options.unique());
        if (!options.language().equals("")) {
            indexOptions.defaultLanguage(options.language());
        }
        if (!options.languageOverride().equals("")) {
            indexOptions.languageOverride(options.languageOverride());
        }
        if (!options.name().equals("")) {
            indexOptions.name(options.name());
        }
        if (options.expireAfterSeconds() != -1) {
            indexOptions.expireAfter(Long.valueOf(options.expireAfterSeconds()), TimeUnit.SECONDS);
        }
        if (!options.partialFilter().equals("")) {
            indexOptions.partialFilterExpression((Bson)Document.parse((String)options.partialFilter()));
        }
        if (!options.collation().locale().equals("")) {
            indexOptions.collation(this.convert(options.collation()));
        }
        return indexOptions;
    }

    com.mongodb.client.model.Collation convert(Collation collation) {
        return com.mongodb.client.model.Collation.builder().locale(collation.locale()).backwards(Boolean.valueOf(collation.backwards())).caseLevel(Boolean.valueOf(collation.caseLevel())).collationAlternate(collation.alternate()).collationCaseFirst(collation.caseFirst()).collationMaxVariable(collation.maxVariable()).collationStrength(collation.strength()).normalization(Boolean.valueOf(collation.normalization())).numericOrdering(Boolean.valueOf(collation.numericOrdering())).build();
    }

    String findField(MappedClass mc, IndexOptions options, List<String> path) {
        String segment = path.get(0);
        if (segment.equals("$**")) {
            return segment;
        }
        MappedField mf = mc.getMappedField(segment);
        if (mf == null) {
            mf = mc.getMappedFieldByJavaField(segment);
        }
        if (mf == null && mc.isInterface()) {
            for (MappedClass mappedClass : this.mapper.getSubTypes(mc)) {
                try {
                    return this.findField(mappedClass, options, new ArrayList<String>(path));
                }
                catch (MappingException mappingException) {
                }
            }
        }
        if (mf == null) {
            if (!options.disableValidation()) {
                throw this.pathFail(mc, path);
            }
            return MorphiaUtils.join(path, '.');
        }
        String namePath = mf.getNameToStore();
        if (path.size() > 1) {
            try {
                Class concreteType = !mf.isSingleValue() ? mf.getSubClass() : mf.getConcreteType();
                namePath = namePath + "." + this.findField(this.mapper.getMappedClass(concreteType), options, path.subList(1, path.size()));
            }
            catch (MappingException e) {
                if (!options.disableValidation()) {
                    throw this.pathFail(mc, path);
                }
                return MorphiaUtils.join(path, '.');
            }
        }
        return namePath;
    }

    void createIndex(MongoCollection collection, MappedClass mc, boolean background) {
        if (!mc.isInterface() && !mc.isAbstract()) {
            for (Index index : this.collectIndexes(mc, Collections.emptyList())) {
                this.createIndex(collection, mc, index, background);
            }
        }
    }

    void createIndex(MongoCollection collection, MappedClass mc, Index index, boolean background) {
        Index normalized = IndexBuilder.normalize(index);
        BsonDocument keys = this.calculateKeys(mc, normalized);
        com.mongodb.client.model.IndexOptions indexOptions = this.convert(normalized.options(), background);
        this.calculateWeights(normalized, indexOptions);
        collection.createIndex((Bson)keys, indexOptions);
    }
}

