Buzz   BVER|  #   PARA  3  MACH    CONN  
   WAVT     PATT  5  SEQU     BLAH     PDLG     MIDI     CWAV                                                                                                                                                                                                                                                     Buzz 1.2 BETA Oct  5 2000 01:19:28    Master Master        Volume      @           BPM            ~   TPB                 PyBuzz Quence PyBuzz       Dummy                  Note                   Byte                  Word                 ch.amp cheapo amp        Max Gain               Gain              Mute                  Inertia              
   2p Filter Geonik's 2p Filter        Type                  CutOff                 Hi Resonance              @   Lo Resonance                 Inertia                  Master                  ~   PyBuzz Quence PyBuzz ?Ծ    
  #
# when 2p filter's cutoff goes above '80' 
# bring up ch. amp's gain from 0 to 65-100%
#
# auto-assigned version (dont have more than one copy of ch.amp or 2p filter)
# read comments below for changing assignments
#
# byte-0 = ch.amp gain
# byte-1 = geonik 2p cutoff
# byte-2 = threshold for cutoff to ch.gain
#

import sys
from buzz import *

print "mute: geonik cutoff to ch.amp loaded\n-----------------------------------\n"

# global namespace -- runs when script is loaded
# look through all the machines loaded in the machine view
# and assign pybuzz 0-byte to ch.amp, 1-byte to geonick 2p filter
# if they are found. also find param max values and set defaults.

x = GetMachineNames()
		
for i in range(len(x)) :
	if x[i] == 'Master' :
		a=1
	else:
		da = GetMachine(x[i])
		y = GetMachineInfo (da)
		z = UnpackMachineInfo(y)
		m = z[10] 			# real machine name, look at 
						# pybuzz reference.txt for index[] info

		p = z[7] 			# list of all parameters, all details

		named = GetMachineName(da) 	# machine name from machine view

		# for auto assignment reasons, you can add a machine to buzz
		# rename them target1, target2, etc.
		# then use if named == "target1": instead of if m == "cheapo amp":
		# etc. this will let you use more than one instance of a machine
		# when auto-assigning. 'Update Import' will be required after you
		# rename or add the machines.
		
			
		if m == "cheapo amp":
	
			pindex = 1 	#what param to control

			SetPeerCtrlTarget(0, da, 1, pindex)
			max = p[pindex][4]
			print "name : " + m 
			print "max value for %s : %i\n" % (p[pindex][1],max)		
			SendPeerCtrlChange(0,1,0)	

		if m == "Geonik's 2p Filter":
	
			pindex2 = 1 	#what param to control

			SetPeerCtrlTarget(1, da, 1, pindex2)
			max2 = p[pindex2][4]
			print "name : " + m 
			print "max value for %s : %i\n" % (p[pindex2][1],max2)	
			SendPeerCtrlChange(1,1,240)		

thresh=80			#default threshold value for cutoff to amp	
SendPeerCtrlChange(2,1,thresh)	#set default threshold

##END ONLOAD##		 

def amp(track,index,value):
	
	global max
	
	#print "[%02i] %i: %i" % (track,index,value)
		
	diff = float(max / 128.0)
	value = value * diff
		
	SendPeerCtrlChange(track,index,value)

def cutoff(track,index,value):
	
	global max2, thresh

	#print "[%02i] %i: %i" % (track,index,value) 

	if (value > thresh): amp(0,1,value)
	if (value < thresh): amp(0,1,0)
		
	diff2 = float(max2 / 128.0)
	value = value *  diff2	 
		
	SendPeerCtrlChange(track,index,value)
			
def OnParameter(track,index,value):
	
	global thresh
	
	if (index == 1 and track == 0):	amp(0,1,value)
	if (index == 1 and track == 1):	cutoff(1,1,value)
	if (index == 1 and track == 2):	thresh = value
	
SetEventTarget("OnParameter",OnParameter)
SetPeerCtrlName(0,"Gain")
SetPeerCtrlName(1,"Cutoff")

Gain ch.amp       Cutoff 2p Filter                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                M   P                                                      ch.amp cheapo amp Ͼp    M.Gain neg. dB [min] `   M.Gain pos. dB [max]     Min Gain %     Max Gain % d   Inertia controlled Mute [0=no]     Inertia type [0=lin,1=exp]     Mute start fade out [ms] 2   Mute end fade in [ms] 2   0 level E.Inertia Out [-dB]    0 level E.Inertia In [-dB]    MidiMuteMode [1=+/-,2=-/+,3=-,+]    MidiMute channel [0=off,17=all]     MidiMute note 0   MidiMute accurary [0=tick,1=rt]    Inertia Len [0 is tick-scale,0< is in ms]     Reverse flag= Gain 1 + Mute 2     Active Inertia [1=/,2=\,3=/\]        
  2p Filter Geonik's 2p Filter ;❾              @ @        00                                                                                                                                                                                                                                                                                              PyBuzz ,          %   x    !  ch.amp ,          &        r  2p Filter ,             C   +         