#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <windows.h>
#include "BladeMP3EncDLL.h"
//#include "resource.h"
  
double const PI = 3.14159265358979323846;

HINSTANCE dllInstance;

#define MAX_BUFFER_LENGTH		256			// in number of samples

class COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack();
	virtual bool __cdecl IsTagged();
	virtual bool __cdecl IsStreamed();
	virtual bool __cdecl IsRequiresWaveout();
	virtual bool __cdecl IsLossyCompression();

	virtual bool __cdecl IsSampleRateChangeable();
	virtual bool __cdecl SampleRateChanged(int samplerate);
	virtual bool __cdecl IsBitRateChangeable();
	virtual bool __cdecl BitRateChanged(int bitrate);

	virtual bool __cdecl SupportsSampleRate(int samplerate);
	virtual bool __cdecl SupportsBitRate(int bitrate);

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name);
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata);

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples);

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain);
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain);

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id);
	virtual char * __cdecl RecordersWebSiteURL();

	virtual int __cdecl RecorderVersion();

	virtual void GetRecorderExtensionsClass(int param, void **exmodule);
};

class rec : public COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack() { return false; };
	virtual bool __cdecl IsTagged() { return false; };
	virtual bool __cdecl IsStreamed() { return false; };
	virtual bool __cdecl IsRequiresWaveout() { return false; };
	virtual bool __cdecl IsLossyCompression() { return false; };

	virtual bool __cdecl IsSampleRateChangeable() { return false; };
	virtual bool __cdecl SampleRateChanged(int samplerate) { return false; };
	virtual bool __cdecl IsBitRateChangeable() { return false; };
	virtual bool __cdecl BitRateChanged(int bitrate) { return false; };

	virtual bool __cdecl SupportsSampleRate(int samplerate) { return true; };
	virtual bool __cdecl SupportsBitRate(int bitrate) { return true; };

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name) { return false; };
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata) { return false; };

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples) { return false; };

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain) { };
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain) { };

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id) { return "No Extra Info"; };
	virtual char * __cdecl RecordersWebSiteURL() { return "http://www.buzzscene.ca"; };

	virtual int __cdecl RecorderVersion() { return 100; };

	virtual void GetRecorderExtensionsClass(int param, void **exmodule) { };
public:
	char myfilename[255];
	FILE * myfilehandle;
	int writtensofar;
	int bitdepth;

	HMODULE				lamedll;
	BEINITSTREAM		beInitStream;
	BEENCODECHUNK		beEncodeChunk;
	BEDEINITSTREAM		beDeinitStream;
	BECLOSESTREAM		beCloseStream;
	BEVERSION			beVersion;
	BEWRITEVBRHEADER	beWriteVBRHeader;
	BE_CONFIG			beConfig;
	BE_VERSION			Version;
	DWORD				dwSamples;
	DWORD				dwMP3Buffer;
	HBE_STREAM			hbeStream;
	BE_ERR				err;
	PBYTE				pMP3Buffer;
	PSHORT				pWAVBuffer;

	DWORD dwRead;
	DWORD dwWrite;
	DWORD dwDone;
	DWORD dwFileSize;

};

bool rec::Init(){
	// Normal LameDLL stuff
	lamedll = LoadLibrary(".\\Gear\\Recorders\\lame_enc.dll");
	if(lamedll==NULL)
	{
		MessageBox(NULL,"Error loading lame_enc.DLL", "Error", MB_OK);
		return false;
	}

	beInitStream	= (BEINITSTREAM) GetProcAddress(lamedll, TEXT_BEINITSTREAM);
	beEncodeChunk	= (BEENCODECHUNK) GetProcAddress(lamedll, TEXT_BEENCODECHUNK);
	beDeinitStream	= (BEDEINITSTREAM) GetProcAddress(lamedll, TEXT_BEDEINITSTREAM);
	beCloseStream	= (BECLOSESTREAM) GetProcAddress(lamedll, TEXT_BECLOSESTREAM);
	beVersion		= (BEVERSION) GetProcAddress(lamedll, TEXT_BEVERSION);
	beWriteVBRHeader= (BEWRITEVBRHEADER) GetProcAddress(lamedll,TEXT_BEWRITEVBRHEADER);

	sprintf(myfilename, "");
	myfilehandle = NULL;
	writtensofar = 0;
	bitdepth = 0;
	return true;
}
bool rec::SaveAs(HWND parentwindow){
	OPENFILENAME ofl;
	char filename[255];
	int nSuccess;

	sprintf(filename,"untitled.mp3");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = parentwindow;
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "MP3 Music Format (*.mp3)\0*.mp3\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Save Song Output as";
	ofl.Flags = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".mp3";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetSaveFileName(&ofl);
	if (nSuccess == 0) {
		sprintf(myfilename, "");
//		SetWindowText(GetDlgItem(hDlg, IDC_FILENAMEBTN), "Save As...");
	} else {
		sprintf(myfilename, ofl.lpstrFile);
//		SetWindowText(GetDlgItem(hDlg, IDC_FILENAMEBTN), ext_hdfilename);
	}
	return true;
}
char *rec::OutputFilename() {
	return myfilename;
}
bool rec::Start (char * filename, int samplespersec) {
	//MessageBox(NULL, "start", "blah", MB_OK);
	myfilehandle = fopen(filename, "wb");

	memset(&beConfig,0,sizeof(beConfig));					// clear all fields
	beConfig.dwConfig = BE_CONFIG_LAME;
	beConfig.format.LHV1.dwStructVersion	= 1;
	beConfig.format.LHV1.dwStructSize		= sizeof(beConfig);		
	beConfig.format.LHV1.dwSampleRate		= 44100;				// INPUT FREQUENCY
	beConfig.format.LHV1.dwReSampleRate		= 0;					// DON"T RESAMPLE
	beConfig.format.LHV1.nMode				= BE_MP3_MODE_JSTEREO;	// OUTPUT IN STREO
	beConfig.format.LHV1.dwBitrate			= 128;					// MINIMUM BIT RATE
	beConfig.format.LHV1.nPreset			= LQP_HIGH_QUALITY;		// QUALITY PRESET SETTING
	beConfig.format.LHV1.dwMpegVersion		= MPEG1;				// MPEG VERSION (I or II)
	beConfig.format.LHV1.dwPsyModel			= 0;					// USE DEFAULT PSYCHOACOUSTIC MODEL 
	beConfig.format.LHV1.dwEmphasis			= 0;					// NO EMPHASIS TURNED ON
	beConfig.format.LHV1.bOriginal			= TRUE;					// SET ORIGINAL FLAG

	beInitStream(&beConfig, &dwSamples, &dwMP3Buffer, &hbeStream);

	pMP3Buffer = new BYTE[dwMP3Buffer];
	pWAVBuffer = new SHORT[dwSamples];

	dwRead=0;
	dwWrite=0;
	dwDone=0;
	dwFileSize=0;
	
	writtensofar = 0;
	return true;
}
bool rec::ReadyToRec() {
	if (strcmp(myfilename, "") == 0) {
		return false;
	} else {
		return true;
	}

}

bool rec::WorkOutput (float *psamples, int numsamples) {
	short psampsm[1024];
	for (int i = 0; i < (numsamples * 2); i++) {
		if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
		if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
		psampsm[i] = (short)psamples[i];
	}
	writtensofar += numsamples;
	dwRead = numsamples * 2;
	// Encode samples
	beEncodeChunk(hbeStream, dwRead, psampsm, pMP3Buffer, &dwWrite);
	fwrite(pMP3Buffer,1,dwWrite,myfilehandle);
	return true;
}

bool rec::Finish() {
	err = beDeinitStream(hbeStream, pMP3Buffer, &dwWrite);

	if(dwWrite)
	{
		if(fwrite(pMP3Buffer,1,dwWrite,myfilehandle) != dwWrite)
		{
			//fprintf(stderr,"Output file write error");
			//return false;
		}
	}

	beCloseStream(hbeStream);
	delete [] pWAVBuffer;
	delete [] pMP3Buffer;


	fflush(myfilehandle);
	fclose(myfilehandle);

	// Write the VBR Tag
//	beWriteVBRHeader(myfilename);

	return true;
}

char * rec::OutputSize() {
	static char megs[32];
	if (bitdepth == 1) {
		sprintf(megs, "%.2fM", ((float)writtensofar * 4.0f / 1024.0f / 1024.0f));
	} else {
		sprintf(megs, "%.2fM", ((float)writtensofar * 2.0f * (float)sizeof(float) / 1024.0f / 1024.0f));
	}
	return megs;
}

rec *prec;

/*BOOL APIENTRY ConfigDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		if (prec->bitdepth == 1) {
//			CheckDlgButton(hDlg,IDC_RADIO16,1);
		} else {
//			CheckDlgButton(hDlg,IDC_RADIO32,1);
		}
		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			
			if (IsDlgButtonChecked(hDlg, IDC_RADIO32) == 1) { prec->bitdepth = 0; }
			if (IsDlgButtonChecked(hDlg, IDC_RADIO16) == 1) { prec->bitdepth = 1; }

			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}*/

void rec::ConfigDlg (HWND parentwindow) {
	//prec = this;
	//DialogBox(dllInstance, MAKEINTRESOURCE (IDD_CONFIG), parentwindow, (DLGPROC) &ConfigDialog);
}

void rec::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {

}

void rec::DispatchCommandEx(char * str_command, char * str_value) {
	if (strcmp(str_command, "about") == 0) {
		// str_value is actually a pointer 
		// to the parent HWND in this case
		HWND parentwindow = *(HWND*)str_value; 
		MessageBox(parentwindow, "MP3 Recorder version 0.0", "About MP3 Recorder", MB_OK | MB_ICONINFORMATION);
	}
}

extern "C" {
__declspec(dllexport) COOERecorder * __cdecl CreateRecorder() { return new rec; }
__declspec(dllexport) char * __cdecl RecInfo() { return "MP3 Recorder"; }
}

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: { dllInstance = (HINSTANCE) hModule; } break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
