"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
var _pluginSyntaxObjectRestSpread = require("@babel/plugin-syntax-object-rest-spread");
function _default({
  types: t
}) {
  return {
    inherits: _pluginSyntaxObjectRestSpread.default,
    visitor: {
      CallExpression(path) {
        if (!path.get("callee").matchesPattern("Object.assign")) return;
        const args = path.get("arguments");
        if (args.length === 0) return;
        const [objPath] = args;
        if (!objPath.isObjectExpression()) return;
        const obj = objPath.node;
        const {
          properties
        } = obj;
        for (let i = 1; i < args.length; i++) {
          const arg = args[i];
          const {
            node
          } = arg;
          if (t.isObjectExpression(node)) {
            properties.push(...node.properties);
          } else {
            properties.push(t.spreadElement(node));
          }
        }
        path.replaceWith(obj);
      }
    }
  };
}

//# sourceMappingURL=index.js.map
