const ruleComposer = require("eslint-rule-composer");
const eslint = require("eslint");
const rule = new eslint.Linter().getRules().get("no-unused-expressions");
function isFinalStatementInBlockStatement(node) {
  const parent = node.parent;
  return /^(?:If|Expression)Statement$/.test(node.type) && parent.type === "BlockStatement" && parent.body[parent.body.length - 1] === node;
}
function isInDoStatement(node) {
  if (!node) return false;
  if (node.type === "DoExpression") return true;
  if (node.type === "IfStatement" && node.parent && node.parent.type === "IfStatement") {
    return isInDoStatement(node.parent);
  }
  if (isFinalStatementInBlockStatement(node)) {
    return isInDoStatement(node.parent.parent);
  }
  return false;
}
function isOptionalCallExpression(node) {
  return !!node && node.type === "ExpressionStatement" && node.expression.type === "ChainExpression" && node.expression.expression.type === "CallExpression";
}
module.exports = ruleComposer.filterReports(rule, problem => !isInDoStatement(problem.node) && !isOptionalCallExpression(problem.node));

//# sourceMappingURL=no-unused-expressions.cjs.map
