/*istanbul ignore start*/
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertChangesToXML = convertChangesToXML;

/*istanbul ignore end*/
function convertChangesToXML(changes) {
  var ret = [];

  for (var i = 0; i < changes.length; i++) {
    var change = changes[i];

    if (change.added) {
      ret.push('<ins>');
    } else if (change.removed) {
      ret.push('<del>');
    }

    ret.push(escapeHTML(change.value));

    if (change.added) {
      ret.push('</ins>');
    } else if (change.removed) {
      ret.push('</del>');
    }
  }

  return ret.join('');
}

function escapeHTML(s) {
  var n = s;
  n = n.replace(/&/g, '&amp;');
  n = n.replace(/</g, '&lt;');
  n = n.replace(/>/g, '&gt;');
  n = n.replace(/"/g, '&quot;');
  return n;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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