(function(modules, cache, entry) {
  window.err-code = req(entry);
  function req(name) {
    if (cache[name]) return cache[name].exports;
    var m = cache[name] = {exports: {}};
    modules[name][0].call(m.exports, modRequire, m, m.exports, window);
    return m.exports;
    function modRequire(alias) {
      var id = modules[name][1][alias];
      if (!id) throw new Error("Cannot find module " + alias);
      return req(id);
    }
  }
})({0: [function(require,module,exports,global){
'use strict';

function assign(obj, props) {
    for (const key in props) {
        Object.defineProperty(obj, key, {
            value: props[key],
            enumerable: true,
            configurable: true,
        });
    }

    return obj;
}

function createError(err, code, props) {
    if (!err || typeof err === 'string') {
        throw new TypeError('Please pass an Error to err-code');
    }

    if (!props) {
        props = {};
    }

    if (typeof code === 'object') {
        props = code;
        code = undefined;
    }

    if (code != null) {
        props.code = code;
    }

    try {
        return assign(err, props);
    } catch (_) {
        props.message = err.message;
        props.stack = err.stack;

        const ErrClass = function () {};

        ErrClass.prototype = Object.create(Object.getPrototypeOf(err));

        return assign(new ErrClass(), props);
    }
}

module.exports = createError;

}, {}],}, {}, 0);
