/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
declare type Status = 'passed' | 'failed' | 'skipped' | 'pending' | 'todo' | 'disabled' | 'focused';
declare type Callsite = {
    column: number;
    line: number;
};
export declare type AssertionResult = {
    ancestorTitles: Array<string>;
    duration?: number | null;
    failureDetails: Array<unknown>;
    failureMessages: Array<string>;
    fullName: string;
    invocations?: number;
    location?: Callsite | null;
    numPassingAsserts: number;
    retryReasons?: Array<string>;
    status: Status;
    title: string;
};
export declare type SerializableError = {
    code?: unknown;
    message: string;
    stack: string | null | undefined;
    type?: string;
};
export {};
