/*istanbul ignore next*/
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.print = print;
exports.PrintVisitor = PrintVisitor;

var
/*istanbul ignore next*/
_visitor = _interopRequireDefault(require("./visitor"));

/*istanbul ignore next*/ function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* eslint-disable new-cap */
function print(ast) {
  return new PrintVisitor().accept(ast);
}

function PrintVisitor() {
  this.padding = 0;
}

PrintVisitor.prototype = new
/*istanbul ignore next*/
_visitor[
/*istanbul ignore next*/
"default"]();

PrintVisitor.prototype.pad = function (string) {
  var out = '';

  for (var i = 0, l = this.padding; i < l; i++) {
    out += '  ';
  }

  out += string + '\n';
  return out;
};

PrintVisitor.prototype.Program = function (program) {
  var out = '',
      body = program.body,
      i,
      l;

  if (program.blockParams) {
    var blockParams = 'BLOCK PARAMS: [';

    for (i = 0, l = program.blockParams.length; i < l; i++) {
      blockParams += ' ' + program.blockParams[i];
    }

    blockParams += ' ]';
    out += this.pad(blockParams);
  }

  for (i = 0, l = body.length; i < l; i++) {
    out += this.accept(body[i]);
  }

  this.padding--;
  return out;
};

PrintVisitor.prototype.MustacheStatement = function (mustache) {
  return this.pad('{{ ' + this.SubExpression(mustache) + ' }}');
};

PrintVisitor.prototype.Decorator = function (mustache) {
  return this.pad('{{ DIRECTIVE ' + this.SubExpression(mustache) + ' }}');
};

PrintVisitor.prototype.BlockStatement = PrintVisitor.prototype.DecoratorBlock = function (block) {
  var out = '';
  out += this.pad((block.type === 'DecoratorBlock' ? 'DIRECTIVE ' : '') + 'BLOCK:');
  this.padding++;
  out += this.pad(this.SubExpression(block));

  if (block.program) {
    out += this.pad('PROGRAM:');
    this.padding++;
    out += this.accept(block.program);
    this.padding--;
  }

  if (block.inverse) {
    if (block.program) {
      this.padding++;
    }

    out += this.pad('{{^}}');
    this.padding++;
    out += this.accept(block.inverse);
    this.padding--;

    if (block.program) {
      this.padding--;
    }
  }

  this.padding--;
  return out;
};

PrintVisitor.prototype.PartialStatement = function (partial) {
  var content = 'PARTIAL:' + partial.name.original;

  if (partial.params[0]) {
    content += ' ' + this.accept(partial.params[0]);
  }

  if (partial.hash) {
    content += ' ' + this.accept(partial.hash);
  }

  return this.pad('{{> ' + content + ' }}');
};

PrintVisitor.prototype.PartialBlockStatement = function (partial) {
  var content = 'PARTIAL BLOCK:' + partial.name.original;

  if (partial.params[0]) {
    content += ' ' + this.accept(partial.params[0]);
  }

  if (partial.hash) {
    content += ' ' + this.accept(partial.hash);
  }

  content += ' ' + this.pad('PROGRAM:');
  this.padding++;
  content += this.accept(partial.program);
  this.padding--;
  return this.pad('{{> ' + content + ' }}');
};

PrintVisitor.prototype.ContentStatement = function (content) {
  return this.pad("CONTENT[ '" + content.value + "' ]");
};

PrintVisitor.prototype.CommentStatement = function (comment) {
  return this.pad("{{! '" + comment.value + "' }}");
};

PrintVisitor.prototype.SubExpression = function (sexpr) {
  var params = sexpr.params,
      paramStrings = [],
      hash;

  for (var i = 0, l = params.length; i < l; i++) {
    paramStrings.push(this.accept(params[i]));
  }

  params = '[' + paramStrings.join(', ') + ']';
  hash = sexpr.hash ? ' ' + this.accept(sexpr.hash) : '';
  return this.accept(sexpr.path) + ' ' + params + hash;
};

PrintVisitor.prototype.PathExpression = function (id) {
  var path = id.parts.join('/');
  return (id.data ? '@' : '') + 'PATH:' + path;
};

PrintVisitor.prototype.StringLiteral = function (string) {
  return '"' + string.value + '"';
};

PrintVisitor.prototype.NumberLiteral = function (number) {
  return 'NUMBER{' + number.value + '}';
};

PrintVisitor.prototype.BooleanLiteral = function (bool) {
  return 'BOOLEAN{' + bool.value + '}';
};

PrintVisitor.prototype.UndefinedLiteral = function () {
  return 'UNDEFINED';
};

PrintVisitor.prototype.NullLiteral = function () {
  return 'NULL';
};

PrintVisitor.prototype.Hash = function (hash) {
  var pairs = hash.pairs,
      joinedPairs = [];

  for (var i = 0, l = pairs.length; i < l; i++) {
    joinedPairs.push(this.accept(pairs[i]));
  }

  return 'HASH{' + joinedPairs.join(', ') + '}';
};

PrintVisitor.prototype.HashPair = function (pair) {
  return pair.key + '=' + this.accept(pair.value);
};
/* eslint-enable new-cap */
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
