/*istanbul ignore next*/
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceLocation = SourceLocation;
exports.id = id;
exports.stripFlags = stripFlags;
exports.stripComment = stripComment;
exports.preparePath = preparePath;
exports.prepareMustache = prepareMustache;
exports.prepareRawBlock = prepareRawBlock;
exports.prepareBlock = prepareBlock;
exports.prepareProgram = prepareProgram;
exports.preparePartialBlock = preparePartialBlock;

var
/*istanbul ignore next*/
_exception = _interopRequireDefault(require("../exception"));

/*istanbul ignore next*/ function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function validateClose(open, close) {
  close = close.path ? close.path.original : close;

  if (open.path.original !== close) {
    var errorNode = {
      loc: open.path.loc
    };
    throw new
    /*istanbul ignore next*/
    _exception[
    /*istanbul ignore next*/
    "default"](open.path.original + " doesn't match " + close, errorNode);
  }
}

function SourceLocation(source, locInfo) {
  this.source = source;
  this.start = {
    line: locInfo.first_line,
    column: locInfo.first_column
  };
  this.end = {
    line: locInfo.last_line,
    column: locInfo.last_column
  };
}

function id(token) {
  if (/^\[.*\]$/.test(token)) {
    return token.substring(1, token.length - 1);
  } else {
    return token;
  }
}

function stripFlags(open, close) {
  return {
    open: open.charAt(2) === '~',
    close: close.charAt(close.length - 3) === '~'
  };
}

function stripComment(comment) {
  return comment.replace(/^\{\{~?!-?-?/, '').replace(/-?-?~?\}\}$/, '');
}

function preparePath(data, parts, loc) {
  loc = this.locInfo(loc);
  var original = data ? '@' : '',
      dig = [],
      depth = 0;

  for (var i = 0, l = parts.length; i < l; i++) {
    var part = parts[i].part,
        // If we have [] syntax then we do not treat path references as operators,
    // i.e. foo.[this] resolves to approximately context.foo['this']
    isLiteral = parts[i].original !== part;
    original += (parts[i].separator || '') + part;

    if (!isLiteral && (part === '..' || part === '.' || part === 'this')) {
      if (dig.length > 0) {
        throw new
        /*istanbul ignore next*/
        _exception[
        /*istanbul ignore next*/
        "default"]('Invalid path: ' + original, {
          loc: loc
        });
      } else if (part === '..') {
        depth++;
      }
    } else {
      dig.push(part);
    }
  }

  return {
    type: 'PathExpression',
    data: data,
    depth: depth,
    parts: dig,
    original: original,
    loc: loc
  };
}

function prepareMustache(path, params, hash, open, strip, locInfo) {
  // Must use charAt to support IE pre-10
  var escapeFlag = open.charAt(3) || open.charAt(2),
      escaped = escapeFlag !== '{' && escapeFlag !== '&';
  var decorator = /\*/.test(open);
  return {
    type: decorator ? 'Decorator' : 'MustacheStatement',
    path: path,
    params: params,
    hash: hash,
    escaped: escaped,
    strip: strip,
    loc: this.locInfo(locInfo)
  };
}

function prepareRawBlock(openRawBlock, contents, close, locInfo) {
  validateClose(openRawBlock, close);
  locInfo = this.locInfo(locInfo);
  var program = {
    type: 'Program',
    body: contents,
    strip: {},
    loc: locInfo
  };
  return {
    type: 'BlockStatement',
    path: openRawBlock.path,
    params: openRawBlock.params,
    hash: openRawBlock.hash,
    program: program,
    openStrip: {},
    inverseStrip: {},
    closeStrip: {},
    loc: locInfo
  };
}

function prepareBlock(openBlock, program, inverseAndProgram, close, inverted, locInfo) {
  if (close && close.path) {
    validateClose(openBlock, close);
  }

  var decorator = /\*/.test(openBlock.open);
  program.blockParams = openBlock.blockParams;
  var inverse, inverseStrip;

  if (inverseAndProgram) {
    if (decorator) {
      throw new
      /*istanbul ignore next*/
      _exception[
      /*istanbul ignore next*/
      "default"]('Unexpected inverse block on decorator', inverseAndProgram);
    }

    if (inverseAndProgram.chain) {
      inverseAndProgram.program.body[0].closeStrip = close.strip;
    }

    inverseStrip = inverseAndProgram.strip;
    inverse = inverseAndProgram.program;
  }

  if (inverted) {
    inverted = inverse;
    inverse = program;
    program = inverted;
  }

  return {
    type: decorator ? 'DecoratorBlock' : 'BlockStatement',
    path: openBlock.path,
    params: openBlock.params,
    hash: openBlock.hash,
    program: program,
    inverse: inverse,
    openStrip: openBlock.strip,
    inverseStrip: inverseStrip,
    closeStrip: close && close.strip,
    loc: this.locInfo(locInfo)
  };
}

function prepareProgram(statements, loc) {
  if (!loc && statements.length) {
    var firstLoc = statements[0].loc,
        lastLoc = statements[statements.length - 1].loc;
    /* istanbul ignore else */

    if (firstLoc && lastLoc) {
      loc = {
        source: firstLoc.source,
        start: {
          line: firstLoc.start.line,
          column: firstLoc.start.column
        },
        end: {
          line: lastLoc.end.line,
          column: lastLoc.end.column
        }
      };
    }
  }

  return {
    type: 'Program',
    body: statements,
    strip: {},
    loc: loc
  };
}

function preparePartialBlock(open, program, close, locInfo) {
  validateClose(open, close);
  return {
    type: 'PartialBlockStatement',
    name: open.path,
    params: open.params,
    hash: open.hash,
    program: program,
    openStrip: open.strip,
    closeStrip: close && close.strip,
    loc: this.locInfo(locInfo)
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
