"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var graphql_1 = require("graphql");
var pack = require('../package.json');
exports.EmptySchema = new graphql_1.GraphQLSchema({
    query: new graphql_1.GraphQLObjectType({
        name: 'Query',
        description: 'Root query',
        fields: {
            version: {
                type: new graphql_1.GraphQLNonNull(graphql_1.GraphQLString),
                resolve: function () { return pack.version; }
            }
        }
    })
});
var app = require('express')();
var graphqlHTTP = require('express-graphql');
app.use('/graphql', graphqlHTTP({
    schema: exports.EmptySchema,
    graphiql: true
}));
app.listen(4000);
