"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var navigation_enum_1 = require("../navigation.enum");
var schema = require('./empty.schema.json');
var projectPackage = require('./projectPackage.json');
describe('pĺugins/navigation.directive#NavigationDirectives', function () {
    var plugin = new navigation_enum_1.default(schema.data.__schema, projectPackage, {});
    test('plugin return navigation', function () {
        var navigations = plugin.getNavigations('Query');
        expect(navigations).toBeInstanceOf(Array);
        expect(navigations).toEqual([
            {
                title: 'Enums',
                items: [
                    { text: '__DirectiveLocation', href: '/directivelocation.spec.html', isActive: false },
                    { text: '__TypeKind', href: '/typekind.spec.html', isActive: false },
                ]
            }
        ]);
    });
});
