"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var navigation_directive_1 = require("../navigation.directive");
var schema = require('./empty.schema.json');
var projectPackage = require('./projectPackage.json');
describe('pĺugins/navigation.directive#NavigationDirectives', function () {
    var plugin = new navigation_directive_1.default(schema.data.__schema, projectPackage, {});
    test('plugin return navigation', function () {
        var navigations = plugin.getNavigations('Query');
        expect(navigations).toBeInstanceOf(Array);
        expect(navigations).toEqual([
            {
                title: 'Directives',
                items: [
                    { text: 'deprecated', href: '/deprecated.doc.html', isActive: false },
                    { text: 'include', href: '/include.doc.html', isActive: false },
                    { text: 'skip', href: '/skip.doc.html', isActive: false },
                ]
            }
        ]);
    });
});
