"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var util_1 = require('util');
exports.TAB_SIZE = 4;
function commandSort(commandA, commandB) {
    var namespaceA = commandA.indexOf(':') >= 0;
    var namespaceB = commandB.indexOf(':') >= 0;
    if (namespaceA && !namespaceB) {
        return 1;
    }
    else if (!namespaceA && namespaceB) {
        return -1;
    }
    else {
        return commandA.localeCompare(commandB);
    }
}
exports.commandSort = commandSort;
function toString(obj) {
    return Object.prototype.toString.call(obj);
}
exports.toString = toString;
;
function repeat(str, len) {
    if (str.repeat)
        return str.repeat(len);
    var result = '';
    while (len > 0) {
        result += str;
        len--;
    }
    return result;
}
exports.repeat = repeat;
exports.RESET = '\u001b[0m';
exports.CSS_TO_COMMAND = {
    'font-weight:bold': '\u001b[1m',
    'font-weight:normal': '\u001b[2m',
    'font-style:italic': '\u001b[3m',
    'text-decoration:underline': '\u001b[4m',
    'visibility:hidden': '\u001b[8m',
    'text-decoration:line-through': '\u001b[9m',
    'color:black': '\u001b[30m',
    'color:red': '\u001b[31m',
    'color:green': '\u001b[32m',
    'color:yellow': '\u001b[33m',
    'color:blue': '\u001b[34m',
    'color:magenta': '\u001b[35m',
    'color:cyan': '\u001b[36m',
    'color:white': '\u001b[37m',
    'color:gray': '\u001b[90m',
    'color:grey': '\u001b[90m',
    'background:black': '\u001b[40m',
    'background:red': '\u001b[41m',
    'background:green': '\u001b[42m',
    'background:yellow': '\u001b[43m',
    'background:blue': '\u001b[44m',
    'background:magenta': '\u001b[45m',
    'background:cyan': '\u001b[46m',
    'background:white': '\u001b[47m',
    'background-color:black': '\u001b[40m',
    'background-color:red': '\u001b[41m',
    'background-color:green': '\u001b[42m',
    'background-color:yellow': '\u001b[43m',
    'background-color:blue': '\u001b[44m',
    'background-color:magenta': '\u001b[45m',
    'background-color:cyan': '\u001b[46m',
    'background-color:white': '\u001b[47m',
};
var Formatter = (function () {
    function Formatter(reset) {
        if (reset === void 0) { reset = ''; }
        this.reset = this.translate(reset);
    }
    Formatter.prototype.translate = function (styles) {
        return '';
    };
    /**
     * The first argument is a string that contains zero or more placeholders.
     * Each placeholder is replaced with the converted value from its
     * corresponding argument. Supported placeholders are:
     *  %s - Formats the value as a string.
     *  %d - Formats the value as a number (both integer and float).
     *  %i - Formats the value as an integer.
     *  %f - Formats the value as an integer.
     *  %c - Formats the output string according to CSS styles you provide.
     *  %j | %o | %O - JSON. Replaced with the string '[Circular]' if the argument contains circular references
     *  %% - single percent sign ('%'). This does not consume an argument.
     *
     * @see https://nodejs.org/api/util.html#util_util_format_format
     * @see https://developer.chrome.com/devtools/docs/console-api#consolelogobject-object
     */
    Formatter.prototype.format = function (str) {
        var _this = this;
        var replacements = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            replacements[_i - 1] = arguments[_i];
        }
        var finalReplacement = [];
        replacements = replacements.slice();
        var finalStr = str.replace(/(%+[c|j|i|f|o|O|d|s|%])/g, function (match) {
            // ignore if no more replacements
            if (replacements.length === 0)
                return match;
            // ignore if match is escaped
            if (match.length % 2 === 1)
                return match;
            // extract replacement value
            var replacement = replacements.shift();
            var placeholder = match.slice(-2);
            var percentages = match.slice(0, -2);
            switch (placeholder) {
                case '%o': // chrome object placeholder
                case '%O':
                    finalReplacement.push(replacement);
                    placeholder = '%j';
                    break;
                case '%c':
                    finalReplacement.push(_this.translate(replacement));
                    placeholder = '%s';
                    break;
                case '%d':
                    typeof replacement === 'object' ?
                        finalReplacement.push(NaN) :
                        finalReplacement.push(Number(replacement));
                    break;
                case '%i':
                    typeof replacement === 'object' ?
                        finalReplacement.push(NaN) :
                        finalReplacement.push(parseInt(replacement));
                    placeholder = '%d';
                    break;
                case '%f':
                    typeof replacement === 'object' ?
                        finalReplacement.push(NaN) :
                        finalReplacement.push(parseFloat(replacement));
                    placeholder = '%d';
                    break;
                case '%j': // node object placeholder
                case '%s':
                    finalReplacement.push(replacement);
                    break;
                default:
                    replacements.push(replacement);
            }
            return percentages + placeholder;
        });
        // native format
        return util_1.format.apply(void 0, [finalStr + this.reset].concat(finalReplacement));
    };
    return Formatter;
}());
exports.Formatter = Formatter;
var ColorFormatter = (function (_super) {
    __extends(ColorFormatter, _super);
    function ColorFormatter() {
        _super.apply(this, arguments);
        this.reset = exports.RESET;
    }
    ColorFormatter.prototype.translate = function (styles) {
        if (typeof styles !== 'string')
            return this.reset || '';
        var commandStyles = styles
            .split(';')
            .map(function (value) {
            var css = value
                .replace(/\s+/g, '')
                .replace(/\/\*[.*]\*\//g, '')
                .toLowerCase();
            if (exports.CSS_TO_COMMAND[css])
                return exports.CSS_TO_COMMAND[css];
            return '';
        })
            .join('');
        return this.reset + commandStyles;
    };
    return ColorFormatter;
}(Formatter));
exports.ColorFormatter = ColorFormatter;
