"use strict";
var path_1 = require('path');
var utils_1 = require('./utils');
function requireCommand(path) {
    var _a = path.split('#'), file = _a[0], name = _a[1];
    var filepath = file[0] === '.' ?
        path_1.resolve(file) :
        require.resolve(file);
    var command = name ?
        require(filepath)[name] :
        require(filepath);
    if (typeof command === 'function') {
        return new QuickCommandProxy(command);
    }
    else if (Object(command) === command) {
        return command;
    }
    else if (name && command === undefined) {
        throw new Error(name + ' not found in ' + path);
    }
    else {
        throw new Error('Unexpected command type resolve: ' + path +
            ' must be a funtion|object instance instead of ' + utils_1.toString(command));
    }
}
/**
 * StringCommandProxy
 */
var StringCommandProxy = (function () {
    function StringCommandProxy(path) {
        this._path = path;
    }
    StringCommandProxy.prototype.command = function () {
        if (!this._command)
            this._command = requireCommand(this._path);
        return this._command;
    };
    Object.defineProperty(StringCommandProxy.prototype, "description", {
        get: function () {
            return this.command().description;
        },
        enumerable: true,
        configurable: true
    });
    StringCommandProxy.prototype.handle = function (input, output) {
        this.command().handle(input, output);
    };
    return StringCommandProxy;
}());
exports.StringCommandProxy = StringCommandProxy;
/**
 * QuickCommandProxy
 *
 *
 */
var QuickCommandProxy = (function () {
    function QuickCommandProxy(quick) {
        this._quick = quick;
    }
    Object.defineProperty(QuickCommandProxy.prototype, "description", {
        get: function () {
            return this._quick.description || '-';
        },
        enumerable: true,
        configurable: true
    });
    QuickCommandProxy.prototype.handle = function (input, output) {
        this._quick(input, output);
    };
    return QuickCommandProxy;
}());
exports.QuickCommandProxy = QuickCommandProxy;
