"use strict";
var util_1 = require('util');
var ParamValue = (function () {
    function ParamValue(definition) {
        // is require?
        if (definition[0] === '[' && definition.slice(-1) === ']') {
            definition = definition.slice(1, -1);
            this.isRequired = false;
        }
        else {
            this.isRequired = true;
        }
        // is list?
        if (definition[0] === '.' &&
            definition[1] === '.' &&
            definition[2] === '.') {
            definition = definition.slice(3);
            this.isList = true;
        }
        else {
            this.isList = false;
        }
        this.name = definition;
    }
    ParamValue.prototype.parse = function (param, input, output) {
        if (this.isList) {
            var list = input.params[this.name] || [];
            list.push(param);
            input.params[this.name] = list;
            return true;
        }
        else if (!(this.name in input.params)) {
            input.params[this.name] = param;
            return true;
        }
        return false;
    };
    ParamValue.prototype.validate = function (input, output) {
        if (!this.isRequired) {
            return true;
        }
        else if (this.isList &&
            Array.isArray(input.params[this.name]) &&
            input.params[this.name].length > 0) {
            return true;
        }
        else if (this.name in input.params &&
            input.params !== '') {
            return true;
        }
        return false;
    };
    return ParamValue;
}());
exports.ParamValue = ParamValue;
/**
 * Usage:
 *  new Param('')
 *  new Param('requireValue')
 *  new Param('...requireListValue')
 *  new Param('[optionalValue]')
 *  new Param('[...optionalListValue]')
 *  new Param('requireValue1 requireValue2 [optionalValue] [...optionalListValue]')
 */
var Param = (function () {
    function Param(definition) {
        this.values = [];
        if (typeof definition !== 'string' || definition === '')
            throw new Error(util_1.format('Invalid Param definition: %j', definition));
        this.definition = definition;
        this.values = definition
            .split(/\s+/i)
            .map(function (def) { return new ParamValue(def); });
    }
    Param.prototype.after = function (input, output) {
        this
            .values
            .forEach(function (value) {
            if (!value.validate(input, output))
                throw new Error(util_1.format('Param %s is required', value.name));
        });
    };
    Param.prototype.before = function (input, output) { };
    Param.prototype.parse = function (param, input, output) {
        var parsed = this
            .values
            .some(function (value) { return value.parse(param, input, output); });
        if (!parsed)
            throw new Error('Unexpected param: ' + param);
    };
    return Param;
}());
exports.Param = Param;
/**
 *
 */
var NoParams = (function () {
    function NoParams() {
        this.definition = '';
    }
    NoParams.prototype.after = function (input, output) { };
    NoParams.prototype.before = function (input, output) { };
    NoParams.prototype.parse = function (param, input, output) {
        throw new Error('Unexpected param: ' + param);
    };
    return NoParams;
}());
exports.NoParams = NoParams;
var IgnoreParams = (function () {
    function IgnoreParams() {
        this.definition = '';
    }
    IgnoreParams.prototype.after = function (input, output) { };
    IgnoreParams.prototype.before = function (input, output) { };
    IgnoreParams.prototype.parse = function (param, input, output) { };
    return IgnoreParams;
}());
exports.IgnoreParams = IgnoreParams;
