import { ParamInterface, InputInterface, OutputInterface } from '../interfaces';
export declare class ParamValue {
    name: string;
    isRequired: boolean;
    isList: boolean;
    constructor(definition: string);
    parse(param: string, input: InputInterface<any, any>, output: OutputInterface): boolean;
    validate(input: InputInterface<any, any>, output: OutputInterface): boolean;
}
/**
 * Usage:
 *  new Param('')
 *  new Param('requireValue')
 *  new Param('...requireListValue')
 *  new Param('[optionalValue]')
 *  new Param('[...optionalListValue]')
 *  new Param('requireValue1 requireValue2 [optionalValue] [...optionalListValue]')
 */
export declare class Param<P> implements ParamInterface<P> {
    definition: string;
    values: ParamValue[];
    constructor(definition: string);
    after(input: InputInterface<any, any>, output: OutputInterface): void;
    before(input: InputInterface<any, any>, output: OutputInterface): void;
    parse(param: string, input: InputInterface<any, any>, output: OutputInterface): void;
}
/**
 *
 */
export declare class NoParams implements ParamInterface<{}> {
    definition: string;
    after(input: InputInterface<any, any>, output: OutputInterface): void;
    before(input: InputInterface<any, any>, output: OutputInterface): void;
    parse(param: string, input: InputInterface<any, any>, output: OutputInterface): void;
}
export declare class IgnoreParams implements ParamInterface<{}> {
    definition: string;
    after(input: InputInterface<any, any>, output: OutputInterface): void;
    before(input: InputInterface<any, any>, output: OutputInterface): void;
    parse(param: string, input: InputInterface<any, any>, output: OutputInterface): void;
}
