export declare const RESET: string;
export declare const CSS_TO_COMMAND: {
    'font-weight:bold': string;
    'font-weight:normal': string;
    'font-style:italic': string;
    'text-decoration:underline': string;
    'visibility:hidden': string;
    'text-decoration:line-through': string;
    'color:black': string;
    'color:red': string;
    'color:green': string;
    'color:yellow': string;
    'color:blue': string;
    'color:magenta': string;
    'color:cyan': string;
    'color:white': string;
    'color:gray': string;
    'color:grey': string;
    'background:black': string;
    'background:red': string;
    'background:green': string;
    'background:yellow': string;
    'background:blue': string;
    'background:magenta': string;
    'background:cyan': string;
    'background:white': string;
    'background-color:black': string;
    'background-color:red': string;
    'background-color:green': string;
    'background-color:yellow': string;
    'background-color:blue': string;
    'background-color:magenta': string;
    'background-color:cyan': string;
    'background-color:white': string;
};
export declare class Formatter {
    reset: string;
    constructor(reset?: string);
    translate(styles: string): string;
    /**
     * The first argument is a string that contains zero or more placeholders.
     * Each placeholder is replaced with the converted value from its
     * corresponding argument. Supported placeholders are:
     *  %s - Formats the value as a string.
     *  %d - Formats the value as a number (both integer and float).
     *  %i - Formats the value as an integer.
     *  %f - Formats the value as an integer.
     *  %c - Formats the output string according to CSS styles you provide.
     *  %j | %o | %O - JSON. Replaced with the string '[Circular]' if the argument contains circular references
     *  %% - single percent sign ('%'). This does not consume an argument.
     *
     * @see https://nodejs.org/api/util.html#util_util_format_format
     * @see https://developer.chrome.com/devtools/docs/console-api#consolelogobject-object
     */
    format(str: string, ...replacements: Array<any>): string;
}
export declare class ColorFormatter extends Formatter {
    reset: string;
    translate(styles: string): string;
}
