"use strict";
var utils_1 = require('../utils');
var OuputExpected = (function () {
    function OuputExpected(expectations) {
        this.count = 0;
        this.expectations = expectations;
    }
    OuputExpected.prototype.log = function (msj) {
        var replacements = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            replacements[_i - 1] = arguments[_i];
        }
        var expect = this.expectations[this.count];
        if (typeof expect !== 'function')
            throw new Error('Unexpected output');
        expect.apply(void 0, [msj].concat(replacements));
        this.count++;
    };
    OuputExpected.prototype.error = function (msj) {
        var replacements = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            replacements[_i - 1] = arguments[_i];
        }
        this.log.apply(this, [msj].concat(replacements));
    };
    return OuputExpected;
}());
exports.OuputExpected = OuputExpected;
/**
 * Ignore all output
 */
var DummyOutput = (function () {
    function DummyOutput() {
    }
    DummyOutput.prototype.log = function () { };
    DummyOutput.prototype.error = function () { };
    return DummyOutput;
}());
exports.DummyOutput = DummyOutput;
var ConsoleOutput = (function () {
    function ConsoleOutput() {
        this.formatter = new utils_1.Formatter;
    }
    ConsoleOutput.prototype.log = function (msj) {
        var obj = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            obj[_i - 1] = arguments[_i];
        }
        if (typeof msj === 'string') {
            console.log((_a = this.formatter).format.apply(_a, [msj].concat(obj)));
        }
        else {
            console.log.apply(console, [msj].concat(obj));
        }
        var _a;
    };
    ConsoleOutput.prototype.error = function (msj) {
        var obj = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            obj[_i - 1] = arguments[_i];
        }
        if (typeof msj === 'string') {
            console.error((_a = this.formatter).format.apply(_a, [msj].concat(obj)));
        }
        else {
            console.error.apply(console, [msj].concat(obj));
        }
        var _a;
    };
    return ConsoleOutput;
}());
exports.ConsoleOutput = ConsoleOutput;
var ColorConsoleOutput = (function () {
    function ColorConsoleOutput() {
        this.formatters = {
            log: new utils_1.ColorFormatter,
            error: new utils_1.ColorFormatter('color:red'),
        };
    }
    ColorConsoleOutput.prototype.log = function (msj) {
        var obj = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            obj[_i - 1] = arguments[_i];
        }
        if (typeof msj === 'string') {
            console.log((_a = this.formatters.log).format.apply(_a, [msj].concat(obj)));
        }
        else {
            console.log.apply(console, [msj].concat(obj));
        }
        var _a;
    };
    ColorConsoleOutput.prototype.error = function (msj) {
        var obj = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            obj[_i - 1] = arguments[_i];
        }
        if (typeof msj === 'string') {
            console.error((_a = this.formatters.error).format.apply(_a, [msj].concat(obj)));
        }
        else {
            console.error.apply(console, [msj].concat(obj));
        }
        var _a;
    };
    return ColorConsoleOutput;
}());
exports.ColorConsoleOutput = ColorConsoleOutput;
