import { OutputInterface, FormatterInterface } from '../../interfaces';
import { ColorFormatter } from '../utils';
/**
 * Output from test
 */
export declare type logger = (msj: string, ...replacements: Array<any>) => void;
export declare class OuputExpected implements OutputInterface {
    count: number;
    expectations: Array<logger>;
    constructor(expectations: Array<logger>);
    log(msj: string, ...replacements: Array<any>): void;
    error(msj: string, ...replacements: Array<any>): void;
}
/**
 * Ignore all output
 */
export declare class DummyOutput implements OutputInterface {
    log(): void;
    error(): void;
}
export declare class ConsoleOutput implements OutputInterface {
    formatter: FormatterInterface;
    log(msj: string, ...obj: Array<any>): void;
    error(msj: string, ...obj: Array<any>): void;
}
export declare class ColorConsoleOutput implements OutputInterface {
    formatters: {
        log: ColorFormatter;
        error: ColorFormatter;
    };
    log(msj: string, ...obj: Array<any>): void;
    error(msj: string, ...obj: Array<any>): void;
}
