"use strict";
var path_1 = require('path');
var executionPaths = process.env.PATH
    .split(process.platform === 'win32' ? ';' : ':');
var ArgvInput = (function () {
    function ArgvInput(argv, exec) {
        if (exec === void 0) { exec = []; }
        this.flags = {};
        this.params = {};
        this.argv = argv.slice();
        this.exec = exec.slice();
        if (exec.length === 0 &&
            argv[0] === process.execPath // is standar execution
        ) {
            var execPath = this.argv.shift();
            var entrypoint = this.argv.shift();
            // command exists on execution path 
            if (executionPaths.indexOf(path_1.dirname(entrypoint)) >= 0) {
                this.exec.push(path_1.basename(entrypoint));
            }
            else {
                this.exec.push(path_1.basename(execPath));
                this.exec.push(path_1.relative(process.cwd(), entrypoint));
            }
        }
    }
    return ArgvInput;
}());
exports.ArgvInput = ArgvInput;
