"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var NullFlag = (function () {
    function NullFlag() {
        this.name = 'NullOption';
        this.description = '';
        this.list = [];
    }
    NullFlag.prototype.after = function () { };
    ;
    NullFlag.prototype.before = function () { };
    ;
    NullFlag.prototype.parse = function () { };
    ;
    return NullFlag;
}());
exports.NullFlag = NullFlag;
var FlagConstructor = (function () {
    function FlagConstructor(name, list, description) {
        if (typeof name !== 'string') {
            throw new Error('Flag name must be a string');
        }
        else if (name.length === 0) {
            throw new Error('Flag name must not be empty');
        }
        else {
            this.name = name;
        }
        if (!Array.isArray(list)) {
            throw new Error('Flag list must be an array');
        }
        else if (name.length === 0) {
            throw new Error('Flag list must not be empty');
        }
        else {
            this.list = list;
        }
        if (typeof description !== 'string') {
            throw new Error('Flag description must be a string');
        }
        else if (description.length === 0) {
            throw new Error('Flag description must not be empty');
        }
        else {
            this.description = description;
        }
    }
    return FlagConstructor;
}());
exports.FlagConstructor = FlagConstructor;
var BooleanFlag = (function (_super) {
    __extends(BooleanFlag, _super);
    function BooleanFlag() {
        _super.apply(this, arguments);
    }
    BooleanFlag.prototype.after = function (input, output) { };
    BooleanFlag.prototype.before = function (input, output) {
        input.flags[this.name] = false;
    };
    BooleanFlag.prototype.parse = function (flag, input, output) {
        input.flags[this.name] = true;
    };
    return BooleanFlag;
}(FlagConstructor));
exports.BooleanFlag = BooleanFlag;
var HelpFlag = (function (_super) {
    __extends(HelpFlag, _super);
    function HelpFlag() {
        _super.call(this, 'help', ['-h', '--help'], 'Print this help');
    }
    return HelpFlag;
}(BooleanFlag));
exports.HelpFlag = HelpFlag;
var RequireFlag = (function () {
    function RequireFlag(flag) {
        this.flag = flag;
    }
    Object.defineProperty(RequireFlag.prototype, "name", {
        get: function () {
            return this.flag.name;
        },
        enumerable: true,
        configurable: true
    });
    ;
    Object.defineProperty(RequireFlag.prototype, "description", {
        get: function () {
            return this.flag.description;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RequireFlag.prototype, "list", {
        get: function () {
            return this.flag.list;
        },
        enumerable: true,
        configurable: true
    });
    RequireFlag.prototype.after = function (input, output) {
        this.flag.after(input, output);
        var value = input.flags[this.name];
        if (value === undefined || value === null ||
            (typeof value === 'number' && isNaN(value)) ||
            value.length === 0)
            throw new Error("Flag " + this.flag.name + " (" + this.flag.list.join(', ') + ") is required");
    };
    RequireFlag.prototype.before = function (input, output) {
        this.flag.before(input, output);
    };
    RequireFlag.prototype.parse = function (flag, input, output) {
        this.flag.parse(flag, input, output);
    };
    return RequireFlag;
}());
exports.RequireFlag = RequireFlag;
var ValueFlag = (function (_super) {
    __extends(ValueFlag, _super);
    function ValueFlag(name, list, description, parser, def) {
        _super.call(this, name, list, description);
        this.parser = parser;
        this.def = def;
    }
    ValueFlag.prototype.after = function (input, output) { };
    ValueFlag.prototype.before = function (input, output) {
        if (typeof this.def !== 'undefined')
            input.flags[this.name] = this.def;
    };
    ValueFlag.prototype.parse = function (falg, input, output) {
        if (input.argv.length === 0 || input.argv[0][0] === '-')
            throw new Error("Flag " + this.name + " (" + this.list.join(', ') + ") expect a value");
        var val = input.argv.shift();
        if (typeof this.parser === 'function')
            input.flags[this.name] = this.parser(val);
        else
            input.flags[this.name] = val;
    };
    return ValueFlag;
}(FlagConstructor));
exports.ValueFlag = ValueFlag;
var ListValueFlag = (function (_super) {
    __extends(ListValueFlag, _super);
    function ListValueFlag(name, list, description, parser, def) {
        _super.call(this, name, list, description);
        this.parser = parser;
        if (arguments.length < 5)
            this.def = [];
        else if (Array.isArray(def))
            this.def = def;
        else
            throw new Error("Flag " + this.name + " (" + this.list.join(', ') + ") default value must be an Array");
    }
    ListValueFlag.prototype.after = function (input, output) {
        if (input.flags[this.name].length === 0)
            input.flags[this.name] = this.def;
    };
    ListValueFlag.prototype.before = function (input, output) {
        input.flags[this.name] = [];
    };
    ListValueFlag.prototype.parse = function (flag, input, output) {
        if (input.argv.length === 0 || input.argv[0][0] === '-')
            throw new Error("Flag " + this.name + " (" + this.list.join(', ') + ") expect a value");
        var val = input.argv.shift();
        input.flags[this.name].push(typeof this.parser === 'function' ? this.parser(val) : val);
    };
    return ListValueFlag;
}(FlagConstructor));
exports.ListValueFlag = ListValueFlag;
