import { InputInterface, OutputInterface, FlagInterface } from '../interfaces';
export declare class NullFlag implements FlagInterface<void> {
    name: string;
    description: string;
    list: any[];
    after(): void;
    before(): void;
    parse(): void;
}
export declare class FlagConstructor {
    name: string;
    description: string;
    list: Array<string>;
    constructor(name?: string, list?: Array<string>, description?: string);
}
export declare class BooleanFlag<F> extends FlagConstructor implements FlagInterface<F> {
    after(input: InputInterface<F, any>, output: OutputInterface): void;
    before(input: InputInterface<F, any>, output: OutputInterface): void;
    parse(flag: string, input: InputInterface<F, any>, output: OutputInterface): void;
}
export declare type HelpFlagInput = {
    help?: boolean;
};
export declare class HelpFlag extends BooleanFlag<HelpFlagInput> implements FlagInterface<HelpFlagInput> {
    constructor();
}
export declare class RequireFlag<F> implements FlagInterface<F> {
    flag: FlagInterface<F>;
    constructor(flag: FlagInterface<F>);
    readonly name: string;
    readonly description: string;
    readonly list: string[];
    after(input: InputInterface<any, any>, output: OutputInterface): void;
    before(input: InputInterface<any, any>, output: OutputInterface): void;
    parse(flag: string, input: InputInterface<any, any>, output: OutputInterface): void;
}
export declare class ValueFlag<T> extends FlagConstructor implements FlagInterface<any> {
    parser: (value: string) => T;
    def: T;
    constructor(name: string, list: Array<string>, description: string, parser?: (value: string) => T, def?: T);
    after(input: InputInterface<any, any>, output: OutputInterface): void;
    before(input: InputInterface<any, any>, output: OutputInterface): void;
    parse(falg: string, input: InputInterface<any, any>, output: OutputInterface): void;
}
export declare class ListValueFlag<T> extends FlagConstructor implements FlagInterface<any> {
    parser: (value: string) => T;
    def: Array<T>;
    constructor(name: string, list: Array<string>, description: string, parser?: (value: string) => T, def?: Array<T>);
    after(input: InputInterface<any, any>, output: OutputInterface): void;
    before(input: InputInterface<any, any>, output: OutputInterface): void;
    parse(flag: string, input: InputInterface<any, any>, output: OutputInterface): void;
}
