import { CommandInterface, CommandType, InputInterface, OutputInterface } from '../interfaces';
import { Param } from './params';
import { SoftCommand } from './command';
export declare type ExecutorParams = {
    COMMAND?: string;
};
export declare type ExecutorFlags = {
    help?: boolean;
};
export declare type CommandListIndex = {
    [command: string]: CommandInterface<any, any>;
};
export declare type CommandTypeListIndex = {
    [command: string]: CommandType;
};
export declare class ExecutorCommand extends SoftCommand<ExecutorParams, ExecutorFlags> {
    _commands: CommandListIndex;
    _hasToConsume: boolean;
    version: string;
    description: string;
    flags: any[];
    params: Param<{}>;
    addCommand(name: string, exec: CommandType): this;
    addCommands(commandList: CommandTypeListIndex): this;
    addCommadsNS(ns: string, commandList: CommandTypeListIndex): this;
    action(input: InputInterface<ExecutorFlags, ExecutorParams>, output: OutputInterface): void;
    hasToConsume(input: InputInterface<ExecutorFlags, ExecutorParams>, output: OutputInterface): boolean;
    /**
     * Return command description
     */
    helpDescription(): string;
    /**
     *
     */
    helpOptions(): Array<string[]>;
}
