import { ParamInterface, FlagInterface, InputInterface, OutputInterface, CommandInterface } from '../interfaces';
export declare class SoftCommand<F, P> implements CommandInterface<F, P> {
    /**
     * Falg index
     */
    _flags: {
        [option: string]: FlagInterface<F>;
    };
    /**
     * Describe command behavior
     */
    description: string;
    /**
     * Parameter definition
     */
    params: ParamInterface<P>;
    /**
     * Flag list
     */
    flags: Array<FlagInterface<F>>;
    /**
     * Help flag
     */
    helpFlag: FlagInterface<F>;
    /**
     * @abstract
     */
    action(input: InputInterface<F, P>, output: OutputInterface): void;
    /**
     * Add option to flag index
     */
    addFlag(flag: FlagInterface<F>): this;
    consume(input: InputInterface<F, P>, output: OutputInterface): void;
    hasToConsume(input: InputInterface<F, P>, output: OutputInterface): boolean;
    /**
     * Parse input and call action method
     */
    handle(input: InputInterface<any, any>, output: OutputInterface): void;
    /**
     * Print help info from command
     */
    help(input: InputInterface<F, P>, output: OutputInterface): void;
    /**
     * Return command description
     */
    helpDescription(): string;
    /**
     * Return usage description
     */
    helpUsage(executable: string): string;
    /**
     * Return flags description
     */
    helpOptions(): Array<string[]>;
    /**
     * Add option list and help flags to flag index
     */
    initialize(): void;
    /**
     * Call parse method from option in flag index
     */
    parseFlag(flag: string, input: InputInterface<F, P>, output: OutputInterface): void;
    /**
     *
     */
    parseParam(param: string, input: InputInterface<F, P>, output: OutputInterface): void;
}
/**
 * Base implementation from command
 */
export declare class Command<F, P> extends SoftCommand<F, P> implements CommandInterface<F, P> {
    /**
     * Add option to flag index
     */
    addFlag(flag: FlagInterface<F>): this;
    initialize(): void;
    /**
     * Call parse method from option in flag index
     */
    parseFlag(flag: string, input: InputInterface<F, P>, output: OutputInterface): void;
}
