#!/bin/bash

# wolfram.sh v.1.1 (c) Copyright 2017, Ward Mundy & Associates LLC. All rights reserved.

# Consume all variables sent by Asterisk
while read VAR && [ -n ${VAR} ] ; do : ; done

# the script expects a random file name to use for STT conversation with IBM Watson
thisfile="$1"

# please insert your IBM Watson STT credentials below
API_USERNAME="XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"
API_PASSWORD="XXXXXXXXXXXX"

# please insert your Wolfram Alpha APPID below
APPID="your-app-id"

# make no changes below here

curl -k -u $API_USERNAME:$API_PASSWORD -X POST --limit-rate 40000 --header "Content-Type: audio/wav" --data-binary @/tmp/$thisfile.wav "https://stream.watsonplatform.net/speech-to-text/api/v1/recognize?continuous=true&model=en-US_NarrowbandModel" 1>/tmp/$thisfile.txt

QUERY=`cat /tmp/$thisfile.txt | grep transcript | cut -f 2 -d ":" | cut -f 2 -d '"' | sed 's| *$||' | sed -e "s/\b\(.\)/\u\1/g"`.

rm /tmp/theanswer.txt

wget -U "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401 Firefox/3.6.3 (.NET CLR 3.5.30729)" -O "/tmp/theanswer.txt" "http://api.wolframalpha.com/v2/query?input='$QUERY'&appid=$APPID&format=plaintext&scantimesout=59"

wait

/var/lib/asterisk/agi-bin/4747.php

# returns results in /tmp/results.txt

wait

rm /tmp/$thisfile.txt
rm /tmp/$thisfile.wav

exit 0
