#!/usr/bin/php -q
<?php
 ob_implicit_flush(false);
 error_reporting(0);
 set_time_limit(300);

//   Nerd Vittles Speechgen.io Interface  ver. 1.0, (c) Copyright Ward Mundy & Associates LLC, 2007-2022. All rights reserved.

//                    This software is licensed under the GPL2 license.
//
//   For a copy of license, visit http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
//


//-------- DON'T CHANGE ANYTHING ABOVE THIS LINE ----------------
 $token           = "your-speechgen-API-token-goes-here";
 $email           = "your-name@gmail.com" ;
 $voice           = "jack";

 $debug = 1;
 $newlogeachdebug = 1;
 $emaildebuglog = 0;


//-------- DON'T CHANGE ANYTHING BELOW THIS LINE ----------------


$log = "/var/log/asterisk/speechgen.txt" ;
if ($debug and $newlogeachdebug) :
 if (file_exists($log)) :
  unlink($log) ;
 endif ;
endif ;

 $stdlog = fopen($log, 'a'); 
 $stdin = fopen('php://stdin', 'r'); 
 $stdout = fopen( 'php://stdout', 'w' ); 

if ($debug) :
  fputs($stdlog, "Nerd Vittles Speechgen.io Interface ver. 1.0 (c) Copyright 2007-2022, Ward Mundy & Associates LLC. All Rights Reserved.\n\n" . date("F j, Y - H:i:s") . "  *** New session ***\n\n" ); 
endif ;

function read() {  
 global $stdin;  
 $input = str_replace("\n", "", fgets($stdin, 4096));  
 dlog("read: $input\n");  
 return $input;  
}  

function write($line) {  
 dlog("write: $line\n");  
 echo $line."\n";  
}  

function dlog($line) { 
 global $debug, $stdlog; 
 if ($debug) fputs($stdlog, $line); 
} 

function execute_agi( $command ) 
{ 
GLOBAL $stdin, $stdout, $stdlog, $debug; 
 
fputs( $stdout, $command . "\n" ); 
fflush( $stdout ); 
if ($debug) 
fputs( $stdlog, $command . "\n" ); 
 
$resp = fgets( $stdin, 4096 ); 
 
if ($debug) 
fputs( $stdlog, $resp ); 
 
if ( preg_match("/^([0-9]{1,3}) (.*)/", $resp, $matches) )  
{ 
if (preg_match('/result=([-0-9a-zA-Z]*)(.*)/', $matches[2], $match))  
{ 
$arr['code'] = $matches[1]; 
$arr['result'] = $match[1]; 
if (isset($match[3]) && $match[3]) 
$arr['data'] = $match[3]; 
return $arr; 
}  
else  
{ 
if ($debug) 
fputs( $stdlog, "Couldn't figure out returned string, Returning code=$matches[1] result=0\n" );  
$arr['code'] = $matches[1]; 
$arr['result'] = 0; 
return $arr; 
} 
}  
else  
{ 
if ($debug) 
fputs( $stdlog, "Could not process string, Returning -1\n" ); 
$arr['code'] = -1; 
$arr['result'] = -1; 
return $arr; 
} 
}  

while ( !feof($stdin) )  
{ 
$temp = fgets( $stdin ); 
 
if ($debug) 
fputs( $stdlog, $temp ); 
 
// Strip off any new-line characters 
$temp = str_replace( "\n", "", $temp ); 
 
$s = explode( ":", $temp ); 
$agivar[$s[0]] = trim( $s[1] ); 
if ( ( $temp == "") || ($temp == "\n") ) 
{ 
break; 
} 
}  

$text2say = $_SERVER["argv"][1];
//$text2say = "Here is a test.";
$lang = $_SERVER["argv"][2];

$text2say = str_replace( "(", "", $text2say );
$text2say = str_replace( ")", "", $text2say );
$text2say = str_replace( ";", ".", $text2say );

unlink ("/tmp/text2say.txt");

$text2say = chr(34) . $text2say . chr(34);

if ($debug) :
 fputs($stdlog, "Text to Say : " . $text2say . "\n\n" );
endif ;


unlink ("/tmp/text.mp3") ;

unlink ("/tmp/spokentext.wav") ;


$data = [
    'token' => "$token",
    'email' => "$email",
    'voice' => "$voice",
    'text' => "$text2say",
    'format' => 'mp3',
    'speed' => 1.1,
    'pitch' => 0,
    'emotion' => 'good',
];
$url = "https://speechgen.io/index.php?r=api/text";
 
$ch = curl_init();
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
 
$response = curl_exec($ch);
var_dump($response);
$response = json_decode($response, true);
if (curl_errno($ch)) {
    var_dump("Connection error with text recognition server, " . curl_error($ch));
} else {
    var_dump($response);
    if ($response["status"] == 1) {
        //Copy
        echo " ok " . $response["file"];
        copy($response["file"], '/tmp/text.' . $response["format"]);
        shell_exec('/usr/bin/sox "/tmp/text.mp3" -c1 -r 8000 "/tmp/spokentext.wav"');
    } else {
        //Error, no voiceover possible
        echo $response["error"];
    }
}
curl_close($ch);

// playback won't work here for some reason. moved it to dialplan.
//$rc = execute_agi("STREAM FILE /tmp/spokentext \"\" ");


if ($emaildebuglog) :
 system("mime-construct --to $email --subject " . chr(34) . "Nerd Vittles Speechgen.io Interface ver. 1.0 Session Log" . chr(34) . " --attachment $log --type text/plain --file $log") ;
endif ;

// clean up file handlers etc.
fclose($stdin);
fclose($stdout);
fclose($stdlog);
exit;

?>
