#!/bin/bash

# smsgen.sh v.1.1 (c) Copyright 2017, Ward Mundy & Associates LLC. All rights reserved.

# Consume all variables sent by Asterisk
while read VAR && [ -n ${VAR} ] ; do : ; done

# the script expects a random file name and SMS number to use for STT conversation with IBM Watson
thisfile="$1"
SMSNUM="$2"

# please insert your IBM Watson STT credentials below
API_USERNAME="XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"
API_PASSWORD="XXXXXXXXXXXX"

# please enter your GVoice account credentials below
GV_NAME="somebody@gmail.com"
GV_PASS="somepassword"

# IMPORTANT: Replace the SMS Dictator context in /etc/asterisk/extensions_custom.conf using the next 3 lines:
#sed -i '\:// BEGIN SMS Dictator:,\:// END SMS Dictator:d' /etc/asterisk/extensions_custom.conf
#sed -i '/\[from-internal-custom\]/r /var/lib/asterisk/agi-bin/sms-767.txt' /etc/asterisk/extensions_custom.conf
#asterisk -rx "dialplan reload"


curl -k -u $API_USERNAME:$API_PASSWORD -X POST --limit-rate 40000 --header "Content-Type: audio/wav" --data-binary @/tmp/$thisfile.wav "https://stream.watsonplatform.net/speech-to-text/api/v1/recognize?continuous=true&model=en-US_NarrowbandModel" 1>/tmp/$thisfile.txt

MSG=`cat /tmp/$thisfile.txt | grep transcript | cut -f 2 -d ":" | cut -f 2 -d '"' | sed 's| *$||' | sed -e "s/\b\(.\)/\u\1/g"`.

gvoice -e $GV_NAME -p $GV_PASS send_sms $SMSNUM "${MSG,,}"

wait

rm /tmp/$thisfile.txt
rm /tmp/$thisfile.wav

exit 0
