#!/usr/bin/php -q
<?php
 ob_implicit_flush(false);
 error_reporting(0);
 set_time_limit(300);
 $ttsengine[0] = "/usr/bin/text2wave" ;
 $ttsengine[1] = "/usr/bin/swift" ;

//   Nerd Vittles ZIP Weather ver. 7.1, (c) Copyright Ward Mundy & Associates LLC, 2007-2018. All rights reserved.

//-------- DON'T CHANGE ANYTHING ABOVE THIS LINE ----------------

 $debug = 1;
 $newlogeachdebug = 1;
 $emaildebuglog = 0;
 $email = "yourname@yourdomain" ;
 $ttspick=0 ;
//-------- DON'T CHANGE ANYTHING BELOW THIS LINE ----------------

$log = "/var/log/asterisk/nv-weather-zip.txt" ;
if ($debug and $newlogeachdebug) :
 if (file_exists($log)) :
  unlink($log) ;
 endif ;
endif ;

 $stdlog = fopen($log, 'a');
 $stdin = fopen('php://stdin', 'r');
 $stdout = fopen( 'php://stdout', 'w' );

if ($debug) :
  fputs($stdlog, "Nerd Vittles ZIP Weather ver 5.2 (c) Copyright 2007-2017, Ward Mundy & Associates LLC. All Rights Reserved.\n\n" . date("F j, Y - H:i:s") . "  *** New session ***\n\n" ); 
endif ;

function read() {
 global $stdin;
 $input = str_replace("\n", "", fgets($stdin, 4096));
 dlog("read: $input\n");
 return $input;
}

function write($line) {
 dlog("write: $line\n");
 echo $line."\n";
}

function dlog($line) {
 global $debug, $stdlog;
 if ($debug) fputs($stdlog, $line);
}

function execute_agi( $command )
{
GLOBAL $stdin, $stdout, $stdlog, $debug;

fputs( $stdout, $command . "\n" );
fflush( $stdout );
if ($debug)
fputs( $stdlog, $command . "\n" );

$resp = fgets( $stdin, 4096 );

if ($debug)
fputs( $stdlog, $resp );

if ( preg_match("/^([0-9]{1,3}) (.*)/", $resp, $matches) )
{
if (preg_match('/result=([-0-9a-zA-Z]*)(.*)/', $matches[2], $match))
{
$arr['code'] = $matches[1];
$arr['result'] = $match[1];
if (isset($match[3]) && $match[3])
$arr['data'] = $match[3];
return $arr;
}
else
{
if ($debug)
fputs( $stdlog, "Couldn't figure out returned string, Returning code=$matches[1] result=0\n" );
$arr['code'] = $matches[1];
$arr['result'] = 0;
return $arr;
}
}
else
{
if ($debug)
fputs( $stdlog, "Could not process string, Returning -1\n" );
$arr['code'] = -1;
$arr['result'] = -1;
return $arr;
}
}

// ------ Code execution begins here
// parse agi headers into array
//while ($env=read()) {
// $s = split(": ",$env);
// $agi[str_replace("agi_","",$s0)] = trim($s1);
// if (($env == "") || ($env == "\n")) {
//   break;
// }
//}

while ( !feof($stdin) )
{
$temp = fgets( $stdin );

if ($debug)
fputs( $stdlog, $temp );

// Strip off any new-line characters
$temp = str_replace( "\n", "", $temp );

$s = explode( ":", $temp );
$agivar[$s[0]] = trim( $s[1] );
if ( ( $temp == "") || ($temp == "\n") )
{
break;
}
}

$dialcode = $_SERVER["argv"][1];

if ($debug) :
fputs($stdlog, "ZIP Code: " . $dialcode . "\n" );
endif ;


$mytts = $ttsengine[$ttspick] ;


$token = md5 (uniqid (""));
$tmptext = "/tmp/tts-$token.txt" ;
//$tmpwave = "/var/lib/asterisk/sounds/tts/tts-$token.wav" ;
$tmpwave = "/tmp/tts-$token.wav" ;


//$fd = fopen("http://pdaweather.org/text.php?city=$dialcode", "r");
//if (!$fd) {
// echo "<p>Unable to open web connection. \n";
// exit;
//}

//$value = "";
//while(!feof($fd)){
//	$value .= fread($fd, 4096);
//}
//fclose($fd);

//--------------


$code = "" ;

 $zip = $dialcode ;
 $answer="/tmp/$zip";
 $citylatlon = file_get_contents("$answer");

 $first=strpos($citylatlon,"|");
 $city=substr($citylatlon,0,$first);
 $citylatlon=substr($citylatlon,$first+1);
 $first=strpos($citylatlon,"|");
 $latitude=substr($citylatlon,1,$first-1);
 $longitude=substr($citylatlon,$first+1,-1);


if ($debug) :
fputs($stdlog, "\nCity: " . $city . "\n\n" );
endif ;
if ($debug) :
fputs($stdlog, "\nLatitude: " . $latitude . "\n\n" );
fputs($stdlog, "\nLongitude: " . $longitude . "\n\n" );
endif ;



if ($debug) :
  fputs($stdlog, "\n\nSTUB: \n\n" );
endif ;


/*
if (strlen($answer)<5) :
 $value= "I'm sorry. No weather information is available for the zip code you have selected. Have a nice day. Good bye." ;
 $fd = fopen($tmptext, "w");
 if (!$fd) {
  echo "<p>Unable to open temporary text file in /tmp for writing. \n";
  exit;
 }
 $retcode = fwrite($fd,$value);
 fclose($fd);
 $retcode2 = system ("echo $value | $mytts -F 8000 -o $tmpwave")
 unlink ("$tmptext") ;
 $tmpwave = "/tmp/tts-$token" ;
 execute_agi("SET VARIABLE TMPWAVE $tmpwave");
 $txt = "mime-construct --file $log --to $email" ;
 if ($debug) :
  fputs($stdlog, "\nSend to Email: " . $txt . "\n\n" );
 endif ;
 fclose($stdin);
 fclose($stdout);
 fclose($stdlog);
 exit ;
endif ;
*/



$query = "http://forecast.weather.gov/MapClick.php?textField1=$latitude&textField2=$longitude";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $query);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36');
$value = curl_exec($ch);
curl_close($ch);

if ($debug) :
  fputs($stdlog, "\nQuery Results: " . $value . "\n\n" );
endif ;


$cityupdate="This National Weather Service update for ". $city . " brought to you by Nerd Vittles. ";

$thetext="myforecast-current";
$start= strpos($value, $thetext);
$value = substr($value,$start);
//$value = substr($value,0,20000);

$cityupdate.="Current local conditions: ";
$thetext=">";
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);

$value = substr($value,$start+$srch_len);
$thetext="</p>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
if (strlen($answer)<4) :
 $cityupdate.=" are not available at this time. ";
else :
$cityupdate.=$answer.". ";

$cityupdate.="Current temperature: ";
$thetext='myforecast-current-lrg">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</p>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$answer= str_replace("&deg;F"," degrees Fahrenheit", $answer);
$cityupdate.=$answer.". ";

$thetext='myforecast-current-sm">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</p>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$answer= str_replace("&deg;C"," degrees Centigrade", $answer);
$cityupdate.=$answer.". ";

$thetext='Humidity">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="<td>";
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</td>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$answer= str_replace("%"," per cent", $answer);
$cityupdate.="Humidity: ".$answer.". ";

$thetext='Wind Speed">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="<td>";
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</td>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$windspeed = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$windspeed = str_replace( "mph","miles per hour", $windspeed );
$windspeed = str_replace( "Vrbl", "Variable at ", $windspeed );
$windspeed = str_replace( "NE ", " From the North East at ", $windspeed );
$windspeed = str_replace( "NW ", " From the North West at ", $windspeed );
$windspeed = str_replace( "SE ", " From the South East at ", $windspeed );
$windspeed = str_replace( "SW ", " From the South West at ", $windspeed );
$windspeed = str_replace( "E ", " From the East at ", $windspeed );
$windspeed = str_replace( "W ", " From the West at ", $windspeed );
$windspeed = str_replace( "N ", " From the North at ", $windspeed );
$windspeed = str_replace( "S ", " From the South at ", $windspeed );
$windspeed = str_replace( "G ", " gusting to ", $windspeed );
$windspeed = str_replace( "NA", " currently unavailable ", $windspeed );
$windspeed = str_replace( "NULL", " currently unavailable ", $windspeed );
$cityupdate.="Wind Speed: ".$windspeed.". ";

$thetext='Barometer">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="<td>";
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</td>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$answer= str_replace(" in"," inches", $answer);
$answer= str_replace(" mb"," millibars", $answer);
$cityupdate.="Barometric Pressure: ".$answer.". ";

$thetext='Visibility">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="<td>";
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="<td>";
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</td>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$answer= str_replace(".00","", $answer);
$answer= str_replace(" mi"," miles", $answer);
$cityupdate.="Visibility: ".$answer.". ";
endif;

$cityupdate.="Here is the latest forecast: ";
$thetext='id="detailed-forecast-body">';
$start= strpos($value, $thetext);
$value = substr($value,$start);
$thetext="/Detailed Forecast";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$value = substr($value,0,$end);


for ( $counter=1; $counter<= 5; $counter += 1) {
$thetext='col-sm-3';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext='<b>';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</b>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$answer = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);
$cityupdate.=$answer.": ";

$thetext='col-sm-9';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext='forecast-text">';
$srch_len=strlen($thetext);
$start= strpos($value, $thetext);
$value = substr($value,$start+$srch_len);
$thetext="</div>";
$srch_len=strlen($thetext);
$end= strpos($value, $thetext);
$forecast = substr($value,0,$end);
$value = substr($value,$end+$srch_len+2);

$forecast = str_replace( ",", " ", $forecast );
$forecast = str_replace( "%", " per cent", $forecast);
$forecast = str_replace( "wind", "wend", $forecast );
$forecast = str_replace( "mph", "miles per hour", $forecast );
$forecast = str_replace( "am.", " a.m.", $forecast );
$forecast = str_replace( "pm.", " p.m.", $forecast );

$cityupdate.=$forecast." ";

}

$cityupdate = str_replace( "  ", " ", $cityupdate );
$cityupdate = str_replace( ".0", " point 0 ", $cityupdate );
$cityupdate = str_replace( ".1", " point 1 ", $cityupdate );
$cityupdate = str_replace( ".2", " point 2 ", $cityupdate );
$cityupdate = str_replace( ".3", " point 3 ", $cityupdate );
$cityupdate = str_replace( ".4", " point 4 ", $cityupdate );
$cityupdate = str_replace( ".5", " point 5 ", $cityupdate );
$cityupdate = str_replace( ".6", " point 6 ", $cityupdate );
$cityupdate = str_replace( ".7", " point 7 ", $cityupdate );
$cityupdate = str_replace( ".8", " point 8 ", $cityupdate );
$cityupdate = str_replace( ".9", " point 9 ", $cityupdate );
$cityupdate = str_replace( "p.m.", "pm.", $cityupdate );
$cityupdate = str_replace( "a.m.", "am.", $cityupdate );
//$cityupdate.="Thank you for calling. Goodbye.";
$msg= chr(34). $cityupdate. " Have a nice day. Goodbye.".chr(34);


if ($debug) :
  fputs($stdlog, "\n\nForecast: " . $cityupdate . "\n\n" );
endif ;

//======================== end of new code


// ============ DONT DELETE BELOW HERE


//$fd = fopen($tmptext, "w");
//if (!$fd) {
// echo "<p>Unable to open temporary text file in /tmp for writing. \n";
// exit;
//}
//$retcode = fwrite($fd,$cityupdate);
//fclose($fd);
//$msg = chr(34) . "Your report was successfully downloaded. Please stand bye." . chr(34) ;
//$retcode2 = system ("cat $tmptext | $mytts -F 8000 -o $tmpwave");
//$tmpwave = "tts-$token" ;
//execute_agi("SET VARIABLE TMPWAVE $tmpwave");
//unlink ("$tmptext") ;

execute_agi("SET VARIABLE WEATHER $msg");

if ($emaildebuglog) :
 system("mime-construct --to $email --subject " . chr(34) . "Nerd Vittles ZIP Weather ver. 5.2 Session Log" . chr(34) . " --attachment $log --type text/plain --file $log") ;
endif ;

// clean up file handlers etc
fclose($stdin);
fclose($stdout);
fclose($stdlog);
exit;
?>
