#!/usr/bin/php -q
<?php
 ob_implicit_flush(false);
 error_reporting(0);
 set_time_limit(300);

//   Nerd Vittles IBM Bluemix TTS Interface  ver. 1.0, (c) Copyright Ward Mundy & Associates LLC, 2007-2017. All rights reserved.

//                    This software is licensed under the GPL2 license.
//
//   For a copy of license, visit http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
//


//-------- DON'T CHANGE ANYTHING ABOVE THIS LINE ----------------

 $IBM_username    = "apikey";
 $IBM_password    = "xxxxxxxxxxxx";
 $IBM_url         = "https://api.us-south.text-to-speech.watson.cloud.ibm.com/instances/c0f27be5-c7ed-4ad6-a6c6-bb779599a7a8";
 $IBM_voice       = "en-US_LisaVoice";
 $email           = "yourname@yourmailserver.com" ;

 $debug = 1;
 $newlogeachdebug = 1;
 $emaildebuglog = 0;


//-------- DON'T CHANGE ANYTHING BELOW THIS LINE ----------------


$log = "/var/log/asterisk/ibmtts.txt" ;
if ($debug and $newlogeachdebug) :
 if (file_exists($log)) :
  unlink($log) ;
 endif ;
endif ;

 $stdlog = fopen($log, 'a'); 
 $stdin = fopen('php://stdin', 'r'); 
 $stdout = fopen( 'php://stdout', 'w' ); 

if ($debug) :
  fputs($stdlog, "Nerd Vittles IBM Bluemix TTS Interface ver. 1.0 (c) Copyright 2007-2017, Ward Mundy & Associates LLC. All Rights Reserved.\n\n" . date("F j, Y - H:i:s") . "  *** New session ***\n\n" ); 
endif ;

function read() {  
 global $stdin;  
 $input = str_replace("\n", "", fgets($stdin, 4096));  
 dlog("read: $input\n");  
 return $input;  
}  

function write($line) {  
 dlog("write: $line\n");  
 echo $line."\n";  
}  

function dlog($line) { 
 global $debug, $stdlog; 
 if ($debug) fputs($stdlog, $line); 
} 

function execute_agi( $command ) 
{ 
GLOBAL $stdin, $stdout, $stdlog, $debug; 
 
fputs( $stdout, $command . "\n" ); 
fflush( $stdout ); 
if ($debug) 
fputs( $stdlog, $command . "\n" ); 
 
$resp = fgets( $stdin, 4096 ); 
 
if ($debug) 
fputs( $stdlog, $resp ); 
 
if ( preg_match("/^([0-9]{1,3}) (.*)/", $resp, $matches) )  
{ 
if (preg_match('/result=([-0-9a-zA-Z]*)(.*)/', $matches[2], $match))  
{ 
$arr['code'] = $matches[1]; 
$arr['result'] = $match[1]; 
if (isset($match[3]) && $match[3]) 
$arr['data'] = $match[3]; 
return $arr; 
}  
else  
{ 
if ($debug) 
fputs( $stdlog, "Couldn't figure out returned string, Returning code=$matches[1] result=0\n" );  
$arr['code'] = $matches[1]; 
$arr['result'] = 0; 
return $arr; 
} 
}  
else  
{ 
if ($debug) 
fputs( $stdlog, "Could not process string, Returning -1\n" ); 
$arr['code'] = -1; 
$arr['result'] = -1; 
return $arr; 
} 
}  

// ------ Code execution begins here
// parse agi headers into array  
//while ($env=read()) {  
// $s = split(": ",$env);  
// $agi[str_replace("agi_","",$s0)] = trim($s1); 
// if (($env == "") || ($env == "\n")) {  
//   break;  
// }  
//}  

while ( !feof($stdin) )  
{ 
$temp = fgets( $stdin ); 
 
if ($debug) 
fputs( $stdlog, $temp ); 
 
// Strip off any new-line characters 
$temp = str_replace( "\n", "", $temp ); 
 
$s = explode( ":", $temp ); 
$agivar[$s[0]] = trim( $s[1] ); 
if ( ( $temp == "") || ($temp == "\n") ) 
{ 
break; 
} 
}  

$text2say = $_SERVER["argv"][1];
//$text2say = "Here is a test.";


$ch = curl_init();

$URL = "$IBM_url" . "/v1/synthesize?voice=" . "$IBM_voice" ;

if ($debug) :
 fputs($stdlog, "Text to Say: " . $text2say . "\n\n" );
 fputs($stdlog, "CURL URL: " . $URL . "\n\n" );
endif ;

curl_setopt($ch, CURLOPT_URL, "$URL");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"text\":\"$text2say\"}");
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_USERPWD, "$IBM_username" . ":" . "$IBM_password");

$headers = array();
$headers[] = "Content-Type: application/json";
$headers[] = "Accept: audio/wav";
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$result = curl_exec($ch);
if (curl_errno($ch)) {
    echo 'Error:' . curl_error($ch);
}

unlink ("/tmp/text2.wav") ;
unlink ("/tmp/text.gsm") ;
unlink ("/tmp/text.wav") ;
$fp = fopen("/tmp/text2.wav", "w");
fwrite($fp,$result);
curl_close ($ch);
fclose($fp);

shell_exec("/usr/bin/sox /tmp/text2.wav -r 8000 -c 1 /tmp/text.wav");

$rc = execute_agi("STREAM FILE /tmp/text \"\" ");

unlink ("/tmp/text2.wav") ;
unlink ("/tmp/text.wav") ;

if ($emaildebuglog) :
 system("mime-construct --to $email --subject " . chr(34) . "Nerd Vittles IBM Bluemix TTS Interface ver. 1.0 Session Log" . chr(34) . " --attachment $log --type text/plain --file $log") ;
endif ;

// clean up file handlers etc.
fclose($stdin);
fclose($stdout);
fclose($stdlog);
exit;

?>
