#!/bin/bash

# getnumber.sh v.1.1 (c) Copyright 2017, Ward Mundy & Associates LLC. All rights reserved.

# Consume all variables sent by Asterisk
while read VAR && [ -n ${VAR} ] ; do : ; done

# the script expects a random file name to use for STT conversation with IBM Watson
thisfile="$1"

# please insert your IBM Watson STT credentials below

API_USERNAME="XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"
API_PASSWORD="XXXXXXXXXXXX"

# IMPORTANT: Replace the Call by Name Context in /etc/asterisk/extensions_custom.conf using the next 3 lines:
#sed -i '\:// BEGIN Call by Name:,\:// END Call by Name:d' /etc/asterisk/extensions_custom.conf
#sed -i '/\[from-internal-custom\]/r /var/lib/asterisk/agi-bin/ibm-411.txt' /etc/asterisk/extensions_custom.conf
#asterisk -rx "dialplan reload"

curl -k -u $API_USERNAME:$API_PASSWORD -X POST --limit-rate 40000 --header "Content-Type: audio/wav" --data-binary @/tmp/$thisfile.wav "https://stream.watsonplatform.net/speech-to-text/api/v1/recognize?continuous=true&model=en-US_NarrowbandModel" 1>/tmp/$thisfile.txt

msg=`cat /tmp/$thisfile.txt | grep transcript | cut -f 2 -d ":" | cut -f 2 -d '"' | sed 's| *$||' | sed -e "s/\b\(.\)/\u\1/g"`%

num2call=$(mysql -uroot -ppassw0rd asteridex -ss -N -e "SELECT user1.out FROM user1 where name LIKE '$msg'");

/bin/rm -f /tmp/$thisfile.*

echo "SET VARIABLE PTY2CALL "\""$msg"\"""
echo "SET VARIABLE NUM2CALL "\""$num2call"\"""

exit 0
