#!/bin/bash
a=`mysql -uroot -ppassw0rd asterisk <<EOF
SHOW DATABASES;
EOF`

DRIVER=`find / -name libmyodbc5.so`
SETUP=`find / -name libodbcmyS.so`

echo "Auto-generating /etc/odbc.ini and /etc/asterisk/res_odbc.conf for the following databases:" 
echo ${a:28}

cd /root
echo "" > odbc.ini
echo "" > odbcinst.ini
echo "" > res_odbc_custom.conf
for DB in ${a:28}
do

  echo "[MySQL-$DB]" >> odbc.ini
  echo "Description     = $DB MySQL ODBC" >> odbc.ini
  echo "Driver          = $DRIVER" >> odbc.ini
  echo "Socket          = /var/lib/mysql/mysql.sock" >> odbc.ini
  echo "Server          = localhost" >> odbc.ini
  echo "User            = root" >> odbc.ini
  echo "Password        = passw0rd" >> odbc.ini
  echo "Port            = 3306" >> odbc.ini
  echo "Database        = $DB" >> odbc.ini
  echo "Option          = 3" >> odbc.ini
  echo " " >> odbc.ini

  echo "[MySQL-$DB]" >> res_odbc_custom.conf
  echo "enabled => yes" >> res_odbc_custom.conf
  echo "dsn => MySQL-$DB" >> res_odbc_custom.conf
  echo "username => root" >> res_odbc_custom.conf
  echo "password => passw0rd" >> res_odbc_custom.conf
  echo "preconnect => yes" >> res_odbc_custom.conf
  echo " " >> res_odbc_custom.conf

done

echo "[MySQL]" >> odbcinst.ini
echo "Description = ODBC for MySQL" >> odbcinst.ini
echo "Driver = $DRIVER" >> odbcinst.ini
echo "Setup = $SETUP" >> odbcinst.ini
echo "FileUsage = 1" >> odbcinst.ini
cp /etc/odbcinst.ini /etc/odbcinst.old
sed '1d' odbcinst.ini > /etc/odbcinst.ini

cp /etc/odbc.ini /etc/odbc.old
sed '1d' odbc.ini > /etc/odbc.ini

cp /etc/asterisk/res_odbc_custom.conf /etc/asterisk/res_odbc_custom.conf.old
sed '1d' res_odbc_custom.conf > /etc/asterisk/res_odbc_custom.conf

chown asterisk:asterisk /etc/asterisk/res_odbc_custom.conf
chmod 664 /etc/asterisk/res_odbc_custom.conf

systemctl restart mysqld
fwconsole restart

echo " "
echo " "
echo "Contents of /etc/odbc.ini..."
echo " "
cat /etc/odbc.ini
echo " "
echo "--------------------------"
echo " "
echo "Contents of /etc/odbcinst.ini..."
echo " "
cat /etc/odbcinst.ini
echo " "
echo "--------------------------"
echo " "
echo "Contents of /etc/asterisk/res_odbc_custom.conf..."
echo " "
cat res_odbc_custom.conf

chown asterisk:asterisk /etc/asterisk/*

echo "Done."

