import { FormatOptions } from './format.js';
export interface Result {
    diff: string;
    match: boolean;
}
export declare const format: (obj: any, options?: FormatOptions) => string;
export declare const same: (obj: any, pattern: any, options?: FormatOptions) => Result;
export declare const strict: (obj: any, pattern: any, options?: FormatOptions) => Result;
export declare const has: (obj: any, pattern: any, options?: FormatOptions) => Result;
export declare const hasStrict: (obj: any, pattern: any, options?: FormatOptions) => Result;
export declare const match: (obj: any, pattern: any, options?: FormatOptions) => Result;
export declare const matchOnly: (obj: any, pattern: any, options?: FormatOptions) => Result;
export declare const matchStrict: (obj: any, pattern: any, options?: FormatOptions) => Result;
export { Format } from './format.js';
export type { FormatOptions } from './format.js';
export { Has } from './has.js';
export { HasStrict } from './has-strict.js';
export { Match } from './match.js';
export { MatchOnly } from './match-only.js';
export { MatchStrict } from './match-strict.js';
export { Same } from './same.js';
export type { SameOptions } from './same.js';
export { Strict } from './strict.js';
export { styles } from './styles.js';
export type { Style } from './styles.js';
