/// <reference types="node" />
import type { Style } from './styles.js';
export interface FormatOptions {
    parent?: Format;
    sort?: boolean;
    seen?: (obj?: any) => false | Format;
    style?: string;
    bufferChunkSize?: number;
    key?: any;
    isKey?: boolean;
    level?: number;
    indent?: string;
    provisional?: boolean;
    includeEnumerable?: boolean;
    includeGetters?: boolean;
    expect?: any;
}
export declare class Format {
    options: FormatOptions;
    parent: Format | null;
    memo: null | string;
    sort: boolean;
    id: null | number;
    idCounter: number;
    idMap: Map<any, number>;
    style: Style;
    bufferChunkSize: number;
    key: any;
    isKey: boolean;
    level: number;
    indent: string;
    match: boolean;
    object: any;
    expect: any;
    constructor(obj: any, options?: FormatOptions);
    incId(): number;
    getId(): number;
    seen(_?: any): false | Format;
    child(obj: any, options: FormatOptions, cls?: typeof Format): any;
    isError(): boolean;
    isArguments(): boolean;
    isArray(): boolean;
    isIterable(): boolean;
    isKeyless(): boolean;
    isStream(): boolean;
    isMap(): boolean;
    isSet(): boolean;
    isBuffer(): boolean;
    isString(): boolean;
    getClass(): string;
    get objectAsArray(): any[] | null;
    print(): string;
    printValue(): void;
    printDate(): void;
    printRegExp(): void;
    printUndefined(): void;
    printNull(): void;
    printSymbol(): void;
    printBigInt(): void;
    printBoolean(): void;
    printNumber(): void;
    printStart(): void;
    printEnd(): void;
    getKey(): string;
    printCircular(seen: Format): void;
    indentLevel(n?: number): string;
    printCollection(): void;
    nodeId(): string;
    printBuffer(): void;
    bufferIsShort(): boolean;
    printBufferHead(): void;
    printBufferBody(): void;
    printBufferLine(key: number, val: Buffer): void;
    printBufferLastLine(key: any, val: Buffer): void;
    printBufferTail(): void;
    printSet(): void;
    setIsEmpty(): boolean;
    printSetEmpty(): void;
    printSetHead(): void;
    printSetBody(): void;
    printSetTail(): void;
    printSetEntry(val: any): void;
    printMap(): void;
    mapIsEmpty(): boolean;
    printMapEmpty(): void;
    printMapHead(): void;
    getMapEntries(obj?: any): [string, any][];
    printMapBody(): void;
    printMapTail(): void;
    printMapEntry(key: any, val: any): void;
    printFn(): void;
    printString(): void;
    stringIsEmpty(): boolean;
    printStringEmpty(): void;
    stringIsOneLine(): boolean;
    printStringOneLine(): void;
    printStringHead(): void;
    printStringBody(): void;
    printStringLine(key: any, val: string): void;
    printStringLastLine(key: any, val: string): void;
    printStringTail(): void;
    printArray(): void;
    arrayIsEmpty(): boolean;
    printArrayEmpty(): void;
    printArrayHead(): void;
    printArrayBody(): void;
    printArrayTail(): void;
    printArrayEntry(key: any, val: any): void;
    printError(): void;
    errorIsEmpty(): boolean;
    printErrorEmpty(): void;
    printErrorHead(): void;
    printErrorTail(): void;
    printErrorBody(): void;
    getPojoKeys(obj?: any): string[];
    printPojo(): void;
    pojoIsEmpty(obj?: any): boolean;
    printPojoEmpty(): void;
    printPojoHead(): void;
    printPojoBody(): void;
    getPojoEntries(obj: any): [string, any][];
    printPojoTail(): void;
    printPojoEntry(key: any, val: any): void;
}
