"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Strict = void 0;
const format_js_1 = require("./format.js");
const same_js_1 = require("./same.js");
class Strict extends same_js_1.Same {
    test() {
        const a = this.object;
        const b = this.expect;
        const st = super.test();
        return st === false
            ? false
            : a === b
                ? true
                : a !== a
                    ? b !== b
                    : typeof a !== 'object' || typeof b !== 'object'
                        ? false
                        : Buffer.isBuffer(a) && Buffer.isBuffer(b)
                            ? st
                            : a instanceof Date && b instanceof Date
                                ? st
                                : a instanceof RegExp && b instanceof RegExp
                                    ? st
                                    : this.isArguments() && !new format_js_1.Format(b).isArguments()
                                        ? false
                                        : a.constructor !== b.constructor &&
                                            !(Array.isArray(b) &&
                                                Array.isArray(b) &&
                                                a.constructor.name === b.constructor.name)
                                            ? false
                                            : 'COMPLEX';
    }
}
exports.Strict = Strict;
//# sourceMappingURL=strict.js.map