import { Format, FormatOptions } from './format.js';
export interface SameOptions extends FormatOptions {
    expect: any;
    parent?: Same;
    key?: any;
    expectKey?: any;
    diffContext?: number;
}
export declare class Same extends Format {
    provisional: boolean;
    expect: any;
    parent: Same | null;
    simple: boolean | 'COMPLEX' | null;
    match: boolean;
    diffContext: number;
    memoDiff: string | null;
    memoExpect: string | null;
    constructor(obj: any, options: SameOptions);
    simpleMatch(): void;
    test(): boolean | "COMPLEX";
    regexpSame(a: RegExp, b: RegExp): boolean;
    unmatch(): void;
    simplePrint(obj: any, options?: FormatOptions): string;
    simplePrintExpect(): string;
    seenExpect(): false | Same;
    print(): string;
    printCircular(seen: Format): void;
    diff(): string;
    child(obj: any, options: FormatOptions | SameOptions, cls?: typeof Same): any;
    childExpect(key: any): any;
    get expectAsArray(): any[] | null;
    printStart(): void;
    printEnd(): void;
    printPojo(): void;
    pojoIsEmpty(): boolean;
    pojoExpectIsEmpty(): boolean;
    printPojoEmpty(): void;
    getPojoKeys(obj?: any): string[];
    printPojoHead(): void;
    printPojoTail(): void;
    printPojoBody(): void;
    printPojoEntry(key: any, val: any, notFound?: boolean): void;
    printError(): void;
    errorIsEmpty(): boolean;
    expectErrorIsEmpty(): boolean;
    printErrorEmpty(): void;
    printErrorHead(): void;
    printErrorTail(): void;
    printMap(): void;
    mapIsEmpty(): boolean;
    mapExpectIsEmpty(): boolean;
    printMapHead(): void;
    printMapTail(): void;
    printMapBody(): void;
    printMapEntry(key: any, val: any, expectKey?: any): void;
    printMapEntryNotFound(key: any, val: any): void;
    printMapEntryUnexpected(key: any, val: any): void;
    printArray(): void;
    arrayIsEmpty(): boolean;
    arrayExpectIsEmpty(): boolean;
    printArrayEmpty(): void;
    printArrayBody(): void;
    printArrayEntry(key: number, val: any): void;
    printSet(): void;
    setExpectIsEmpty(): boolean;
    setIsEmpty(): boolean;
    printSetBody(): void;
}
